/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.kafka.clients.KafkaPropagation;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.clients.TracingCallback;
import brave.propagation.TraceContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import zipkin2.Endpoint;

final class TracingProducer<K, V>
implements Producer<K, V> {
    final Tracing tracing;
    final TraceContext.Injector<Headers> injector;
    final Producer<K, V> delegate;
    @Nullable
    final String remoteServiceName;

    TracingProducer(Tracing tracing, Producer<K, V> delegate, @Nullable String remoteServiceName) {
        this.delegate = delegate;
        this.tracing = tracing;
        this.injector = tracing.propagation().injector(KafkaPropagation.HEADER_SETTER);
        this.remoteServiceName = remoteServiceName;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() {
        this.delegate.beginTransaction();
    }

    public void commitTransaction() {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() {
        this.delegate.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, @Nullable Callback callback) {
        Span span = this.tracing.tracer().nextSpan();
        this.tracing.propagation().keys().forEach(key -> record.headers().remove(key));
        this.injector.inject(span.context(), (Object)record.headers());
        if (!span.isNoop()) {
            if (record.key() instanceof String && !"".equals(record.key())) {
                span.tag("kafka.key", record.key().toString());
            }
            if (this.remoteServiceName != null) {
                span.remoteEndpoint(Endpoint.newBuilder().serviceName(this.remoteServiceName).build());
            }
            span.tag("kafka.topic", record.topic()).name("send").kind(Span.Kind.PRODUCER).start();
        }
        try (Tracer.SpanInScope ws = this.tracing.tracer().withSpanInScope(span);){
            Future future = this.delegate.send(record, (Callback)new TracingCallback(span, callback));
            return future;
        }
        catch (Error | RuntimeException e) {
            KafkaTracing.finish(span, e);
            throw e;
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(long timeout, TimeUnit unit) {
        this.delegate.close(timeout, unit);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
    }
}

