/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.ProcessorContext;
import zipkin2.Call;

abstract class TracingFilter<K, V, R> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final String spanName;
    final Predicate<K, V> delegatePredicate;
    final Tracer tracer;
    final boolean filterNot;
    ProcessorContext processorContext;

    TracingFilter(KafkaStreamsTracing kafkaStreamsTracing, String spanName, Predicate<K, V> delegatePredicate, boolean filterNot) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegatePredicate = delegatePredicate;
        this.filterNot = filterNot;
    }

    public void init(ProcessorContext context) {
        this.processorContext = context;
    }

    public R transform(K key, V value) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            if (this.filterNot ^ this.delegatePredicate.test(key, value)) {
                span.tag("kafka.streams.filtered", "false");
                R r = this.result(key, value);
                return r;
            }
            span.tag("kafka.streams.filtered", "true");
            R r = null;
            return r;
        }
        catch (Throwable e) {
            error = e;
            Call.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            if (error != null) {
                span.error(error);
            }
            span.finish();
            ws.close();
        }
    }

    abstract R result(K var1, V var2);
}

