/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.streams.AbstractTracingTransformer;
import brave.kafka.streams.AbstractTracingValueTransformer;
import brave.kafka.streams.AbstractTracingValueTransformerWithKey;
import brave.kafka.streams.KafkaStreamsPropagation;
import brave.kafka.streams.TracingFilterTransformerSupplier;
import brave.kafka.streams.TracingFilterValueTransformerWithKeySupplier;
import brave.kafka.streams.TracingKafkaClientSupplier;
import brave.kafka.streams.TracingProcessorSupplier;
import brave.kafka.streams.TracingTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerWithKeySupplier;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public final class KafkaStreamsTracing {
    final KafkaTracing kafkaTracing;
    final Tracer tracer;
    final TraceContext.Extractor<Headers> extractor;
    final TraceContext.Injector<Headers> injector;
    final Set<String> propagationKeys;
    final TraceContextOrSamplingFlags emptyExtraction;

    KafkaStreamsTracing(Builder builder) {
        this.kafkaTracing = builder.kafkaTracing.toBuilder().singleRootSpanOnReceiveBatch(builder.singleRootSpanOnReceiveBatch).build();
        this.tracer = this.kafkaTracing.messagingTracing().tracing().tracer();
        Propagation propagation = this.kafkaTracing.messagingTracing().tracing().propagation();
        this.extractor = propagation.extractor(KafkaStreamsPropagation.GETTER);
        this.injector = propagation.injector(KafkaStreamsPropagation.SETTER);
        this.propagationKeys = new LinkedHashSet<String>(propagation.keys());
        this.emptyExtraction = propagation.extractor((c, k) -> null).extract((Object)Boolean.TRUE);
    }

    public static KafkaStreamsTracing create(Tracing tracing) {
        return KafkaStreamsTracing.create(KafkaTracing.create((Tracing)tracing));
    }

    public static KafkaStreamsTracing create(MessagingTracing messagingTracing) {
        return new Builder(KafkaTracing.create((MessagingTracing)messagingTracing)).build();
    }

    public static KafkaStreamsTracing create(KafkaTracing kafkaTracing) {
        return new Builder(kafkaTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(KafkaTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(KafkaTracing.create((MessagingTracing)messagingTracing));
    }

    public KafkaClientSupplier kafkaClientSupplier() {
        return new TracingKafkaClientSupplier(this.kafkaTracing);
    }

    public KafkaStreams kafkaStreams(Topology topology, Properties streamsConfig) {
        return new KafkaStreams(topology, streamsConfig, this.kafkaClientSupplier());
    }

    public <K, V> ProcessorSupplier<K, V> processor(String spanName, ProcessorSupplier<K, V> processorSupplier) {
        return new TracingProcessorSupplier<K, V>(this, spanName, processorSupplier);
    }

    public <K, V, R> TransformerSupplier<K, V, R> transformer(String spanName, TransformerSupplier<K, V, R> transformerSupplier) {
        return new TracingTransformerSupplier<K, V, R>(this, spanName, transformerSupplier);
    }

    public <V, VR> ValueTransformerSupplier<V, VR> valueTransformer(String spanName, ValueTransformerSupplier<V, VR> valueTransformerSupplier) {
        return new TracingValueTransformerSupplier<V, VR>(this, spanName, valueTransformerSupplier);
    }

    public <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKey(String spanName, ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKeySupplier) {
        return new TracingValueTransformerWithKeySupplier<K, V, VR>(this, spanName, valueTransformerWithKeySupplier);
    }

    public <K, V> ProcessorSupplier<K, V> foreach(String spanName, final ForeachAction<K, V> action) {
        return new TracingProcessorSupplier(this, spanName, () -> new AbstractProcessor<K, V>(){

            public void process(K key, V value) {
                action.apply(key, value);
            }
        });
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> peek(String spanName, final ForeachAction<K, V> action) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, V>(){

            public V transform(K key, V value) {
                action.apply(key, value);
                return value;
            }
        });
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> mark(String spanName) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, V>(){

            public V transform(K key, V value) {
                return value;
            }
        });
    }

    public <K, V, KR, VR> TransformerSupplier<K, V, KeyValue<KR, VR>> map(String spanName, final KeyValueMapper<K, V, KeyValue<KR, VR>> mapper) {
        return new TracingTransformerSupplier(this, spanName, () -> new AbstractTracingTransformer<K, V, KeyValue<KR, VR>>(){

            public KeyValue<KR, VR> transform(K key, V value) {
                return (KeyValue)mapper.apply(key, value);
            }
        });
    }

    public <K, V, KR, VR> TransformerSupplier<K, V, Iterable<KeyValue<KR, VR>>> flatMap(String spanName, final KeyValueMapper<K, V, Iterable<KeyValue<KR, VR>>> mapper) {
        return new TracingTransformerSupplier(this, spanName, () -> new AbstractTracingTransformer<K, V, Iterable<KeyValue<KR, VR>>>(){

            public Iterable<KeyValue<KR, VR>> transform(K key, V value) {
                return (Iterable)mapper.apply(key, value);
            }
        });
    }

    public <K, V> TransformerSupplier<K, V, KeyValue<K, V>> filter(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterTransformerSupplier<K, V>(this, spanName, predicate, false);
    }

    public <K, V> TransformerSupplier<K, V, KeyValue<K, V>> filterNot(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterTransformerSupplier<K, V>(this, spanName, predicate, true);
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> markAsFiltered(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterValueTransformerWithKeySupplier<K, V>(this, spanName, predicate, false);
    }

    public <K, V> ValueTransformerWithKeySupplier<K, V, V> markAsNotFiltered(String spanName, Predicate<K, V> predicate) {
        return new TracingFilterValueTransformerWithKeySupplier<K, V>(this, spanName, predicate, true);
    }

    public <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> mapValues(String spanName, final ValueMapperWithKey<K, V, VR> mapper) {
        return new TracingValueTransformerWithKeySupplier(this, spanName, () -> new AbstractTracingValueTransformerWithKey<K, V, VR>(){

            public VR transform(K readOnlyKey, V value) {
                return mapper.apply(readOnlyKey, value);
            }
        });
    }

    public <V, VR> ValueTransformerSupplier<V, VR> mapValues(String spanName, final ValueMapper<V, VR> mapper) {
        return new TracingValueTransformerSupplier(this, spanName, () -> new AbstractTracingValueTransformer<V, VR>(){

            public VR transform(V value) {
                return mapper.apply(value);
            }
        });
    }

    static void addTags(ProcessorContext processorContext, SpanCustomizer result) {
        result.tag("kafka.streams.application.id", processorContext.applicationId());
        result.tag("kafka.streams.task.id", processorContext.taskId().toString());
    }

    Span nextSpan(ProcessorContext context) {
        Span result;
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)context.headers());
        if (!extracted.equals((Object)this.emptyExtraction)) {
            this.clearHeaders(context.headers());
        }
        if (!(result = this.tracer.nextSpan(extracted)).isNoop()) {
            KafkaStreamsTracing.addTags(context, (SpanCustomizer)result);
        }
        return result;
    }

    void clearHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Header next = (Header)i.next();
            if (!this.propagationKeys.contains(next.key())) continue;
            i.remove();
        }
    }

    public static final class Builder {
        final KafkaTracing kafkaTracing;
        boolean singleRootSpanOnReceiveBatch = false;

        Builder(KafkaTracing kafkaTracing) {
            if (kafkaTracing == null) {
                throw new NullPointerException("kafkaTracing == null");
            }
            this.kafkaTracing = kafkaTracing;
        }

        public Builder singleRootSpanOnReceiveBatch(boolean singleRootSpanOnReceiveBatch) {
            this.singleRootSpanOnReceiveBatch = singleRootSpanOnReceiveBatch;
            return this;
        }

        public KafkaStreamsTracing build() {
            return new KafkaStreamsTracing(this);
        }
    }
}

