/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingProcessor<K, V>
implements Processor<K, V> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String name;
    final Processor<K, V> delegateProcessor;
    ProcessorContext processorContext;

    TracingProcessor(KafkaStreamsTracing kafkaStreamsTracing, String name, Processor<K, V> delegateProcessor) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracing.tracer();
        this.name = name;
        this.delegateProcessor = delegateProcessor;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateProcessor.init(processorContext);
    }

    public void process(K k, V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.name);
            span.start();
        }
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);){
            this.delegateProcessor.process(k, v);
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void close() {
        this.delegateProcessor.close();
    }
}

