/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.streams.KafkaStreamsPropagation;
import brave.kafka.streams.TracingKafkaClientSupplier;
import brave.kafka.streams.TracingProcessorSupplier;
import brave.kafka.streams.TracingTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerSupplier;
import brave.kafka.streams.TracingValueTransformerWithKeySupplier;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Properties;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public final class KafkaStreamsTracing {
    final Tracing tracing;
    final TraceContext.Extractor<Headers> extractor;

    KafkaStreamsTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(KafkaStreamsPropagation.GETTER);
    }

    public static KafkaStreamsTracing create(Tracing tracing) {
        return new Builder(tracing).build();
    }

    public KafkaStreams kafkaStreams(Topology topology, Properties streamsConfig) {
        KafkaTracing kafkaTracing = KafkaTracing.create((Tracing)this.tracing);
        TracingKafkaClientSupplier kafkaClientSupplier = new TracingKafkaClientSupplier(kafkaTracing);
        return new KafkaStreams(topology, streamsConfig, (KafkaClientSupplier)kafkaClientSupplier);
    }

    public <K, V> ProcessorSupplier<K, V> processor(String name, Processor<K, V> processor) {
        return new TracingProcessorSupplier<K, V>(this, name, processor);
    }

    public <K, V, R> TransformerSupplier<K, V, R> transformer(String name, Transformer<K, V, R> transformer) {
        return new TracingTransformerSupplier<K, V, R>(this, name, transformer);
    }

    public <V, VR> ValueTransformerSupplier<V, VR> valueTransformer(String name, ValueTransformer<V, VR> valueTransformer) {
        return new TracingValueTransformerSupplier<V, VR>(this, name, valueTransformer);
    }

    public <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKey(String name, ValueTransformerWithKey<K, V, VR> valueTransformerWithKey) {
        return new TracingValueTransformerWithKeySupplier<K, V, VR>(this, name, valueTransformerWithKey);
    }

    static void addTags(ProcessorContext processorContext, SpanCustomizer result) {
        result.tag("kafka.streams.application.id", processorContext.applicationId());
        result.tag("kafka.streams.task.id", processorContext.taskId().toString());
    }

    Span nextSpan(ProcessorContext context) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)context.headers());
        Span result = this.tracing.tracer().nextSpan(extracted);
        if (!result.isNoop()) {
            KafkaStreamsTracing.addTags(context, (SpanCustomizer)result);
        }
        return result;
    }

    public static final class Builder {
        final Tracing tracing;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public KafkaStreamsTracing build() {
            return new KafkaStreamsTracing(this);
        }
    }
}

