/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.AbstractTracingTransformer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingFilterTransformer<K, V>
extends AbstractTracingTransformer<K, V, KeyValue<K, V>> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final String spanName;
    final Predicate<K, V> delegatePredicate;
    final Tracer tracer;
    final boolean filterNot;
    ProcessorContext processorContext;

    TracingFilterTransformer(KafkaStreamsTracing tracing, String spanName, Predicate<K, V> delegatePredicate, boolean filterNot) {
        this.kafkaStreamsTracing = tracing;
        this.tracer = this.kafkaStreamsTracing.tracing.tracer();
        this.spanName = spanName;
        this.delegatePredicate = delegatePredicate;
        this.filterNot = filterNot;
    }

    @Override
    public void init(ProcessorContext context) {
        this.processorContext = context;
    }

    public KeyValue<K, V> transform(K key, V value) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        try {
            KeyValue<K, V> keyValue;
            block16: {
                Tracer.SpanInScope ws;
                block14: {
                    KeyValue keyValue2;
                    block15: {
                        ws = this.tracer.withSpanInScope(span);
                        try {
                            if (!(this.filterNot ^ this.delegatePredicate.test(key, value))) break block14;
                            span.tag("kafka.streams.filtered", "false");
                            keyValue2 = KeyValue.pair(key, value);
                            if (ws == null) break block15;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ws != null) {
                                    try {
                                        ws.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Error | RuntimeException e) {
                                span.error(e);
                                throw e;
                            }
                        }
                        ws.close();
                    }
                    return keyValue2;
                }
                span.tag("kafka.streams.filtered", "true");
                keyValue = null;
                if (ws == null) break block16;
                ws.close();
            }
            return keyValue;
        }
        finally {
            span.finish();
        }
    }
}

