/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingTransformer<K, V, R>
implements Transformer<K, V, R> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final Transformer<K, V, R> delegateTransformer;
    ProcessorContext processorContext;

    TracingTransformer(KafkaStreamsTracing kafkaStreamsTracing, String spanName, Transformer<K, V, R> delegateTransformer) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracing.tracer();
        this.spanName = spanName;
        this.delegateTransformer = delegateTransformer;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateTransformer.init(processorContext);
    }

    public R transform(K k, V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        try {
            Object object;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
                try {
                    Object transform = this.delegateTransformer.transform(k, v);
                    this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
                    object = transform;
                    if (ws == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        span.error(e);
                        throw e;
                    }
                }
                ws.close();
            }
            return (R)object;
        }
        finally {
            span.finish();
        }
    }

    public void close() {
        this.delegateTransformer.close();
    }
}

