/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.streams.KafkaStreamsPropagation;
import brave.kafka.streams.TracingFixedKeyProcessorSupplier;
import brave.kafka.streams.TracingKafkaClientSupplier;
import brave.kafka.streams.TracingProcessorSupplier;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessingContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;

public final class KafkaStreamsTracing {
    final KafkaTracing kafkaTracing;
    final Tracer tracer;
    final TraceContext.Extractor<Headers> extractor;
    final TraceContext.Injector<Headers> injector;
    final Set<String> propagationKeys;
    final TraceContextOrSamplingFlags emptyExtraction;

    KafkaStreamsTracing(Builder builder) {
        this.kafkaTracing = builder.kafkaTracing.toBuilder().singleRootSpanOnReceiveBatch(builder.singleRootSpanOnReceiveBatch).build();
        this.tracer = this.kafkaTracing.messagingTracing().tracing().tracer();
        Propagation propagation = this.kafkaTracing.messagingTracing().propagation();
        this.extractor = propagation.extractor(KafkaStreamsPropagation.GETTER);
        this.injector = propagation.injector(KafkaStreamsPropagation.SETTER);
        this.propagationKeys = new LinkedHashSet<String>(propagation.keys());
        this.emptyExtraction = propagation.extractor((c, k) -> null).extract((Object)Boolean.TRUE);
    }

    public static KafkaStreamsTracing create(Tracing tracing) {
        return KafkaStreamsTracing.create(KafkaTracing.create((Tracing)tracing));
    }

    public static KafkaStreamsTracing create(MessagingTracing messagingTracing) {
        return new Builder(KafkaTracing.create((MessagingTracing)messagingTracing)).build();
    }

    public static KafkaStreamsTracing create(KafkaTracing kafkaTracing) {
        return new Builder(kafkaTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(KafkaTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(KafkaTracing.create((MessagingTracing)messagingTracing));
    }

    public KafkaClientSupplier kafkaClientSupplier() {
        return new TracingKafkaClientSupplier(this.kafkaTracing);
    }

    public KafkaStreams kafkaStreams(Topology topology, Properties streamsConfig) {
        return new KafkaStreams(topology, streamsConfig, this.kafkaClientSupplier());
    }

    public <KIn, VIn, KOut, VOut> ProcessorSupplier<KIn, VIn, KOut, VOut> process(String spanName, ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier) {
        return new TracingProcessorSupplier<KIn, VIn, KOut, VOut>(this, spanName, processorSupplier);
    }

    public <KIn, VIn, VOut> FixedKeyProcessorSupplier<KIn, VIn, VOut> processValues(String spanName, FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier) {
        return new TracingFixedKeyProcessorSupplier<KIn, VIn, VOut>(this, spanName, processorSupplier);
    }

    static void addTags(ProcessorContext processorContext, SpanCustomizer result) {
        result.tag("kafka.streams.application.id", processorContext.applicationId());
        result.tag("kafka.streams.task.id", processorContext.taskId().toString());
    }

    static void addTags(ProcessingContext processingContext, SpanCustomizer result) {
        result.tag("kafka.streams.application.id", processingContext.applicationId());
        result.tag("kafka.streams.task.id", processingContext.taskId().toString());
    }

    Span nextSpan(ProcessingContext context, Headers headers) {
        Span result;
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        if (!extracted.equals((Object)this.emptyExtraction)) {
            this.clearHeaders(headers);
        }
        if (!(result = this.tracer.nextSpan(extracted)).isNoop()) {
            KafkaStreamsTracing.addTags(context, (SpanCustomizer)result);
        }
        return result;
    }

    void clearHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Header next = (Header)i.next();
            if (!this.propagationKeys.contains(next.key())) continue;
            i.remove();
        }
    }

    public static final class Builder {
        final KafkaTracing kafkaTracing;
        boolean singleRootSpanOnReceiveBatch = false;

        Builder(KafkaTracing kafkaTracing) {
            if (kafkaTracing == null) {
                throw new NullPointerException("kafkaTracing == null");
            }
            this.kafkaTracing = kafkaTracing;
        }

        public Builder singleRootSpanOnReceiveBatch(boolean singleRootSpanOnReceiveBatch) {
            this.singleRootSpanOnReceiveBatch = singleRootSpanOnReceiveBatch;
            return this;
        }

        public KafkaStreamsTracing build() {
            return new KafkaStreamsTracing(this);
        }
    }
}

