/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.internal.Throwables;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.api.ProcessingContext;

abstract class BaseTracingProcessor<C extends ProcessingContext, R, P> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final P delegate;
    C context;

    BaseTracingProcessor(KafkaStreamsTracing kafkaStreamsTracing, String spanName, P delegate) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegate = delegate;
    }

    abstract Headers headers(R var1);

    abstract void process(P var1, R var2);

    public void process(R record) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.context, this.headers(record));
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            this.process(this.delegate, record);
        }
        catch (Throwable e) {
            error = e;
            Throwables.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.headers(record));
            if (error != null) {
                span.error(error);
            }
            span.finish();
            scope.close();
        }
    }
}

