/*
 * Decompiled with CFR 0.152.
 */
package brave.mongodb;

import brave.Span;
import brave.Tracer;
import brave.internal.Nullable;
import brave.mongodb.MongoDBTracing;
import brave.propagation.ThreadLocalSpan;
import com.mongodb.MongoSocketException;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;

final class TraceMongoCommandListener
implements CommandListener {
    static final Set<String> COMMANDS_WITH_COLLECTION_NAME = new LinkedHashSet<String>(Arrays.asList("aggregate", "count", "distinct", "mapReduce", "geoSearch", "delete", "find", "findAndModify", "insert", "update", "collMod", "compact", "convertToCapped", "create", "createIndexes", "drop", "dropIndexes", "killCursors", "listIndexes", "reIndex"));
    final ThreadLocalSpan threadLocalSpan;

    TraceMongoCommandListener(MongoDBTracing mongoDBTracing) {
        this(ThreadLocalSpan.create((Tracer)mongoDBTracing.tracing.tracer()));
    }

    TraceMongoCommandListener(ThreadLocalSpan threadLocalSpan) {
        this.threadLocalSpan = threadLocalSpan;
    }

    public void commandStarted(CommandStartedEvent event) {
        ConnectionDescription connectionDescription;
        Span span = this.threadLocalSpan.next();
        if (span == null || span.isNoop()) {
            return;
        }
        String commandName = event.getCommandName();
        String databaseName = event.getDatabaseName();
        BsonDocument command = event.getCommand();
        String collectionName = this.getCollectionName(command, commandName);
        span.name(TraceMongoCommandListener.getSpanName(commandName, collectionName)).kind(Span.Kind.CLIENT).remoteServiceName("mongodb-" + databaseName).tag("mongodb.command", commandName);
        if (collectionName != null) {
            span.tag("mongodb.collection", collectionName);
        }
        if ((connectionDescription = event.getConnectionDescription()) != null) {
            ConnectionId connectionId = connectionDescription.getConnectionId();
            if (connectionId != null) {
                span.tag("mongodb.cluster_id", connectionId.getServerId().getClusterId().getValue());
            }
            try {
                InetSocketAddress socketAddress = connectionDescription.getServerAddress().getSocketAddress();
                span.remoteIpAndPort(socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
            }
            catch (MongoSocketException mongoSocketException) {
                // empty catch block
            }
        }
        span.start();
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        Span span = this.threadLocalSpan.remove();
        if (span == null) {
            return;
        }
        span.finish();
    }

    public void commandFailed(CommandFailedEvent event) {
        Span span = this.threadLocalSpan.remove();
        if (span == null) {
            return;
        }
        span.error(event.getThrowable());
        span.finish();
    }

    @Nullable
    String getCollectionName(BsonDocument command, String commandName) {
        String collectionName;
        if (COMMANDS_WITH_COLLECTION_NAME.contains(commandName) && (collectionName = TraceMongoCommandListener.getNonEmptyBsonString(command.get((Object)commandName))) != null) {
            return collectionName;
        }
        return TraceMongoCommandListener.getNonEmptyBsonString(command.get((Object)"collection"));
    }

    @Nullable
    static String getNonEmptyBsonString(BsonValue bsonValue) {
        if (bsonValue == null || !bsonValue.isString()) {
            return null;
        }
        String stringValue = bsonValue.asString().getValue().trim();
        return stringValue.isEmpty() ? null : stringValue;
    }

    static String getSpanName(String commandName, @Nullable String collectionName) {
        if (collectionName == null) {
            return commandName;
        }
        return commandName + " " + collectionName;
    }
}

