/*
 * Decompiled with CFR 0.152.
 */
package brave.netty.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.internal.Platform;
import brave.netty.http.HttpNettyAdapter;
import brave.netty.http.NettyHttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;

final class TracingHttpServerHandler
extends ChannelDuplexHandler {
    static final Propagation.Getter<HttpHeaders, String> GETTER = new Propagation.Getter<HttpHeaders, String>(){

        public String get(HttpHeaders carrier, String key) {
            return carrier.get(key);
        }

        public String toString() {
            return "HttpHeaders::get";
        }
    };
    final Tracer tracer;
    final HttpNettyAdapter adapter;
    final TraceContext.Extractor<HttpHeaders> extractor;
    final HttpSampler sampler;
    final HttpServerParser parser;

    TracingHttpServerHandler(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverSampler();
        this.parser = httpTracing.serverParser();
        this.adapter = new HttpNettyAdapter();
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        HttpRequest request = (HttpRequest)msg;
        Span span = this.nextSpan(this.extractor.extract((Object)request.headers()), request).kind(Span.Kind.SERVER);
        ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE).set((Object)span);
        Tracer.SpanInScope spanInScope = this.tracer.withSpanInScope(span);
        ctx.channel().attr(NettyHttpTracing.SPAN_IN_SCOPE_ATTRIBUTE).set((Object)spanInScope);
        try {
            if (!span.isNoop()) {
                this.parseChannelAddress(ctx, request, span);
                this.parser.request((HttpAdapter)this.adapter, (Object)request, span.customizer());
                span.start();
            }
            ctx.fireChannelRead(msg);
            spanInScope.close();
        }
        catch (Error | RuntimeException e) {
            spanInScope.close();
            span.error(e).finish();
            throw e;
        }
    }

    void parseChannelAddress(ChannelHandlerContext ctx, HttpRequest request, Span span) {
        if (this.adapter.parseClientIpFromXForwardedFor(request, span)) {
            return;
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        if (remoteAddress.getAddress() == null) {
            return;
        }
        span.remoteIpAndPort(Platform.get().getHostString(remoteAddress), remoteAddress.getPort());
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, HttpRequest request) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = this.sampler.trySample((HttpAdapter)this.adapter, (Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) {
        Span span = (Span)ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE).get();
        if (span == null || !(msg instanceof HttpResponse)) {
            ctx.write(msg, prm);
            return;
        }
        HttpResponse response = (HttpResponse)msg;
        Tracer.SpanInScope spanInScope = (Tracer.SpanInScope)ctx.channel().attr(NettyHttpTracing.SPAN_IN_SCOPE_ATTRIBUTE).get();
        if (spanInScope == null) {
            spanInScope = this.tracer.withSpanInScope(span);
        }
        try {
            ctx.write(msg, prm);
            this.parser.response((HttpAdapter)this.adapter, (Object)response, null, span.customizer());
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            throw e;
        }
        finally {
            spanInScope.close();
            span.finish();
        }
    }
}

