/*
 * Decompiled with CFR 0.152.
 */
package brave.netty.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.netty.http.NettyHttpTracing;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.net.URI;

final class TracingHttpServerHandler
extends ChannelDuplexHandler {
    final HttpServerHandler<brave.http.HttpServerRequest, brave.http.HttpServerResponse> handler;
    final Tracer tracer;

    TracingHttpServerHandler(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        HttpServerRequest request = new HttpServerRequest((HttpRequest)msg, (InetSocketAddress)ctx.channel().remoteAddress());
        Span span = this.handler.handleReceive((brave.http.HttpServerRequest)request);
        ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE).set((Object)span);
        Tracer.SpanInScope spanInScope = this.tracer.withSpanInScope(span);
        ctx.channel().attr(NettyHttpTracing.SPAN_IN_SCOPE_ATTRIBUTE).set((Object)spanInScope);
        try {
            ctx.fireChannelRead(msg);
            spanInScope.close();
        }
        catch (Error | RuntimeException e) {
            spanInScope.close();
            span.error(e).finish();
            throw e;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) {
        Span span = (Span)ctx.channel().attr(NettyHttpTracing.SPAN_ATTRIBUTE).get();
        if (span == null || !(msg instanceof HttpResponse)) {
            ctx.write(msg, prm);
            return;
        }
        HttpResponse response = (HttpResponse)msg;
        Tracer.SpanInScope spanInScope = (Tracer.SpanInScope)ctx.channel().attr(NettyHttpTracing.SPAN_IN_SCOPE_ATTRIBUTE).get();
        if (spanInScope == null) {
            spanInScope = this.tracer.withSpanInScope(span);
        }
        Throwable t = null;
        try {
            ctx.write(msg, prm);
        }
        catch (Error | RuntimeException e) {
            t = e;
            throw e;
        }
        finally {
            spanInScope.close();
            this.handler.handleSend((Object)new HttpServerResponse(response), t, span);
        }
    }

    static final class HttpServerResponse
    extends brave.http.HttpServerResponse {
        final HttpResponse delegate;

        HttpServerResponse(HttpResponse delegate) {
            this.delegate = delegate;
        }

        public HttpResponse unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            HttpResponseStatus status = this.delegate.status();
            return status != null ? status.code() : 0;
        }
    }

    static final class HttpServerRequest
    extends brave.http.HttpServerRequest {
        final HttpRequest request;
        @Nullable
        final InetSocketAddress remoteAddress;

        HttpServerRequest(HttpRequest request, InetSocketAddress remoteAddress) {
            this.request = request;
            this.remoteAddress = remoteAddress;
        }

        public HttpRequest unwrap() {
            return this.request;
        }

        public boolean parseClientIpAndPort(Span span) {
            if (this.remoteAddress.getAddress() == null) {
                return false;
            }
            return span.remoteIpAndPort(Platform.get().getHostString(this.remoteAddress), this.remoteAddress.getPort());
        }

        public String method() {
            return this.request.method().name();
        }

        public String path() {
            return URI.create(this.request.uri()).getPath();
        }

        public String url() {
            String host = this.header("Host");
            if (host == null) {
                return null;
            }
            return "http://" + host + this.request.uri();
        }

        public String header(String name) {
            return this.request.headers().get(name);
        }
    }
}

