/*
 * Decompiled with CFR 0.152.
 */
package brave.okhttp3;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okio.Timeout;

final class TraceContextCall
implements Call {
    final Call delegate;
    final CurrentTraceContext currentTraceContext;
    final TraceContext invocationContext;

    TraceContextCall(Call delegate, CurrentTraceContext currentTraceContext, TraceContext invocationContext) {
        this.delegate = delegate;
        this.currentTraceContext = currentTraceContext;
        this.invocationContext = invocationContext;
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public Call clone() {
        return new TraceContextCall(this.delegate.clone(), this.currentTraceContext, this.invocationContext);
    }

    public void enqueue(Callback callback) {
        this.delegate.enqueue((Callback)(callback != null ? new TraceContextCallback(this, callback) : null));
    }

    public Response execute() throws IOException {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
            Response response = this.delegate.execute();
            return response;
        }
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public Request request() {
        return this.delegate.request();
    }

    public Timeout timeout() {
        return this.delegate.timeout();
    }

    public String toString() {
        return this.delegate.toString();
    }

    static final class TraceContextCallback
    implements Callback {
        final Callback delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextCallback(TraceContextCall call, Callback delegate) {
            this.delegate = delegate;
            this.currentTraceContext = call.currentTraceContext;
            this.invocationContext = call.invocationContext;
        }

        public void onResponse(Call call, Response response) throws IOException {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onResponse(call, response);
            }
        }

        public void onFailure(Call call, IOException e) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate.onFailure(call, e);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

