/*
 * Decompiled with CFR 0.152.
 */
package brave.okhttp3;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class TracingInterceptor
implements Interceptor {
    static final Propagation.Setter<Request.Builder, String> SETTER = new Propagation.Setter<Request.Builder, String>(){

        public void put(Request.Builder carrier, String key, String value) {
            carrier.header(key, value);
        }

        public String toString() {
            return "Request.Builder::header";
        }
    };
    final Tracer tracer;
    final String remoteServiceName;
    final HttpClientHandler<Request, Response> handler;
    final TraceContext.Injector<Request.Builder> injector;

    public static Interceptor create(Tracing tracing) {
        return TracingInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static Interceptor create(HttpTracing httpTracing) {
        return new TracingInterceptor(httpTracing);
    }

    TracingInterceptor(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.tracer = httpTracing.tracing().tracer();
        this.remoteServiceName = httpTracing.serverName();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
    }

    /*
     * Loose catch block
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Tracer.SpanInScope ws;
        Throwable error;
        Response response2;
        Span span;
        block10: {
            Request request = chain.request();
            Request.Builder requestBuilder = request.newBuilder();
            span = this.handler.handleSend(this.injector, (Object)requestBuilder, (Object)request);
            TracingInterceptor.parseRouteAddress(chain, span);
            response2 = null;
            error = null;
            ws = this.tracer.withSpanInScope(span);
            response = response2 = chain.proceed(requestBuilder.build());
            if (ws == null) break block10;
            ws.close();
        }
        this.handler.handleReceive((Object)response2, error, span);
        return response;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | Error | RuntimeException e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive(response2, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static void parseRouteAddress(Interceptor.Chain chain, Span span) {
        if (span.isNoop()) {
            return;
        }
        Connection connection = chain.connection();
        if (connection == null) {
            return;
        }
        InetSocketAddress socketAddress = connection.route().socketAddress();
        span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
    }

    static final class HttpAdapter
    extends HttpClientAdapter<Request, Response> {
        HttpAdapter() {
        }

        public String method(Request request) {
            return request.method();
        }

        public String path(Request request) {
            return request.url().encodedPath();
        }

        public String url(Request request) {
            return request.url().toString();
        }

        public String requestHeader(Request request, String name) {
            return request.header(name);
        }

        public Integer statusCode(Response response) {
            return this.statusCodeAsInt(response);
        }

        public int statusCodeAsInt(Response response) {
            return response.code();
        }
    }
}

