/*
 * Decompiled with CFR 0.152.
 */
package brave.p6spy;

import brave.Span;
import brave.internal.Nullable;
import brave.propagation.ThreadLocalSpan;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import com.p6spy.engine.logging.P6LogLoadableOptions;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TracingJdbcEventListener
extends SimpleJdbcEventListener {
    private static final Pattern URL_SERVICE_NAME_FINDER = Pattern.compile("zipkinServiceName=(.*?)(?:&|$)");
    @Nullable
    final String remoteServiceName;
    final boolean includeParameterValues;
    final P6LogLoadableOptions logOptions;

    TracingJdbcEventListener(@Nullable String remoteServiceName, boolean includeParameterValues, P6LogLoadableOptions logOptions) {
        this.remoteServiceName = remoteServiceName;
        this.includeParameterValues = includeParameterValues;
        this.logOptions = logOptions;
    }

    public void onBeforeAnyExecute(StatementInformation info) {
        String sql;
        String string = sql = this.includeParameterValues ? info.getSqlWithValues() : info.getSql();
        if (!this.isLoggable(sql)) {
            return;
        }
        Span span = ThreadLocalSpan.CURRENT_TRACER.next();
        if (span == null || span.isNoop()) {
            return;
        }
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        this.parseServerIpAndPort(info.getConnectionInformation().getConnection(), span);
        span.start();
    }

    public void onAfterAnyExecute(StatementInformation info, long elapsed, SQLException e) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (e != null) {
            span.error((Throwable)e);
            span.tag("error", Integer.toString(e.getErrorCode()));
        }
        span.finish();
    }

    boolean isLoggable(String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (!this.logOptions.getFilter()) {
            return true;
        }
        Pattern sqlExpressionPattern = this.logOptions.getSQLExpressionPattern();
        Pattern includeExcludePattern = this.logOptions.getIncludeExcludePattern();
        return !(sqlExpressionPattern != null && !sqlExpressionPattern.matcher(sql).matches() || includeExcludePattern != null && !includeExcludePattern.matcher(sql).matches());
    }

    void parseServerIpAndPort(Connection connection, Span span) {
        try {
            String parsedServiceName;
            String urlAsString = connection.getMetaData().getURL().substring(5);
            URI url = URI.create(urlAsString.replace(" ", ""));
            String defaultRemoteServiceName = this.remoteServiceName;
            Matcher matcher = URL_SERVICE_NAME_FINDER.matcher(url.toString());
            if (matcher.find() && matcher.groupCount() == 1 && (parsedServiceName = matcher.group(1)) != null && !parsedServiceName.isEmpty()) {
                defaultRemoteServiceName = parsedServiceName;
            }
            if (defaultRemoteServiceName == null || "".equals(defaultRemoteServiceName)) {
                String databaseName = connection.getCatalog();
                if (databaseName != null && !databaseName.isEmpty()) {
                    span.remoteServiceName(databaseName);
                }
            } else {
                span.remoteServiceName(defaultRemoteServiceName);
            }
            span.remoteIpAndPort(url.getHost(), url.getPort());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

