/*
 * Decompiled with CFR 0.152.
 */
package brave.servlet;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.internal.Nullable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import zipkin2.Call;

abstract class ServletRuntime {
    private static final ServletRuntime SERVLET_RUNTIME = ServletRuntime.findServletRuntime();

    HttpServletResponse httpResponse(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    @Nullable
    abstract Integer status(HttpServletResponse var1);

    abstract boolean isAsync(HttpServletRequest var1);

    abstract void handleAsync(HttpServerHandler<HttpServletRequest, HttpServletResponse> var1, HttpServletRequest var2, Span var3);

    ServletRuntime() {
    }

    static ServletRuntime get() {
        return SERVLET_RUNTIME;
    }

    private static ServletRuntime findServletRuntime() {
        try {
            Class.forName("javax.servlet.AsyncEvent");
            HttpServletRequest.class.getMethod("isAsyncStarted", new Class[0]);
            return new Servlet3();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Servlet25();
    }

    static final class Servlet25ServerResponseAdapter
    extends HttpServletResponseWrapper {
        int httpStatus = 200;

        Servlet25ServerResponseAdapter(ServletResponse response) {
            super((HttpServletResponse)response);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatusInServlet25() {
            return this.httpStatus;
        }
    }

    static final class Servlet25
    extends ServletRuntime {
        final AtomicReference<Map<Class<?>, Object>> classToGetStatus = new AtomicReference(new LinkedHashMap());
        static final String RETURN_NULL = "RETURN_NULL";

        Servlet25() {
        }

        @Override
        HttpServletResponse httpResponse(ServletResponse response) {
            return new Servlet25ServerResponseAdapter(response);
        }

        @Override
        boolean isAsync(HttpServletRequest request) {
            return false;
        }

        @Override
        void handleAsync(HttpServerHandler<HttpServletRequest, HttpServletResponse> handler, HttpServletRequest request, Span span) {
            assert (false) : "this should never be called in Servlet 2.5";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        Integer status(HttpServletResponse response) {
            if (response instanceof Servlet25ServerResponseAdapter) {
                return ((Servlet25ServerResponseAdapter)response).getStatusInServlet25();
            }
            Class<?> clazz = response.getClass();
            Map<Class<?>, Object> classesToCheck = this.classToGetStatus.get();
            Object getStatusMethod = classesToCheck.get(clazz);
            if (getStatusMethod == RETURN_NULL || getStatusMethod == null && classesToCheck.size() == 10) {
                return null;
            }
            if (getStatusMethod == null) {
                if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
                    return null;
                }
                try {
                    getStatusMethod = clazz.getMethod("getStatus", new Class[0]);
                    Integer n = (int)((Integer)((Method)getStatusMethod).invoke((Object)response, new Object[0]));
                    return n;
                }
                catch (Throwable throwable) {
                    Call.propagateIfFatal((Throwable)throwable);
                    getStatusMethod = RETURN_NULL;
                    Integer replacement = null;
                    return replacement;
                }
                finally {
                    LinkedHashMap replacement = new LinkedHashMap(classesToCheck);
                    replacement.put(clazz, getStatusMethod);
                    this.classToGetStatus.set(replacement);
                }
            }
            try {
                return (int)((Integer)((Method)getStatusMethod).invoke((Object)response, new Object[0]));
            }
            catch (Throwable throwable) {
                Call.propagateIfFatal((Throwable)throwable);
                LinkedHashMap replacement = new LinkedHashMap(classesToCheck);
                replacement.put(clazz, RETURN_NULL);
                this.classToGetStatus.set(replacement);
                return null;
            }
        }
    }

    static final class Servlet3
    extends ServletRuntime {
        Servlet3() {
        }

        @Override
        boolean isAsync(HttpServletRequest request) {
            return request.isAsyncStarted();
        }

        @Override
        @Nullable
        Integer status(HttpServletResponse response) {
            return response.getStatus();
        }

        @Override
        void handleAsync(HttpServerHandler<HttpServletRequest, HttpServletResponse> handler, HttpServletRequest request, Span span) {
            if (span.isNoop()) {
                return;
            }
            request.getAsyncContext().addListener((AsyncListener)new TracingAsyncListener(handler, span));
        }

        static final class TracingAsyncListener
        implements AsyncListener {
            final HttpServerHandler<HttpServletRequest, HttpServletResponse> handler;
            final Span span;
            volatile boolean complete;

            TracingAsyncListener(HttpServerHandler<HttpServletRequest, HttpServletResponse> handler, Span span) {
                this.handler = handler;
                this.span = span;
            }

            public void onComplete(AsyncEvent e) {
                if (this.complete) {
                    return;
                }
                this.handler.handleSend((Object)((HttpServletResponse)e.getSuppliedResponse()), null, this.span);
                this.complete = true;
            }

            public void onTimeout(AsyncEvent e) {
                if (this.complete) {
                    return;
                }
                this.span.tag("error", String.format("Timed out after %sms", e.getAsyncContext().getTimeout()));
                this.handler.handleSend((Object)((HttpServletResponse)e.getSuppliedResponse()), null, this.span);
                this.complete = true;
            }

            public void onError(AsyncEvent e) {
                if (this.complete) {
                    return;
                }
                this.handler.handleSend(null, e.getThrowable(), this.span);
                this.complete = true;
            }

            public void onStartAsync(AsyncEvent event) {
                AsyncContext eventAsyncContext = event.getAsyncContext();
                if (eventAsyncContext != null) {
                    eventAsyncContext.addListener((AsyncListener)this);
                }
            }

            public String toString() {
                return "TracingAsyncListener{" + this.span.context() + "}";
            }
        }
    }
}

