/*
 * Decompiled with CFR 0.152.
 */
package brave.sparkjava;

import brave.Span;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.servlet.HttpServletRequestWrapper;
import brave.servlet.HttpServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import spark.ExceptionHandler;
import spark.Filter;

public final class SparkTracing {
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;

    public static SparkTracing create(Tracing tracing) {
        return new SparkTracing(HttpTracing.create((Tracing)tracing));
    }

    public static SparkTracing create(HttpTracing httpTracing) {
        return new SparkTracing(httpTracing);
    }

    SparkTracing(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    public Filter before() {
        return (request, response) -> {
            Span span = this.handler.handleReceive(HttpServletRequestWrapper.create((HttpServletRequest)request.raw()));
            request.attribute(Span.class.getName(), (Object)span);
            request.attribute(CurrentTraceContext.Scope.class.getName(), (Object)this.currentTraceContext.newScope(span.context()));
        };
    }

    public Filter afterAfter() {
        return (req, res) -> {
            Span span = (Span)req.attribute(Span.class.getName());
            if (span == null) {
                return;
            }
            HttpServerResponse response = HttpServletResponseWrapper.create((HttpServletRequest)req.raw(), (HttpServletResponse)res.raw(), null);
            this.handler.handleSend(response, span);
            ((CurrentTraceContext.Scope)req.attribute(CurrentTraceContext.Scope.class.getName())).close();
        };
    }

    public ExceptionHandler exception(ExceptionHandler delegate) {
        return (error, req, res) -> {
            try {
                delegate.handle(error, req, res);
            }
            finally {
                Span span = (Span)req.attribute(Span.class.getName());
                if (span != null) {
                    HttpServerResponse response = HttpServletResponseWrapper.create((HttpServletRequest)req.raw(), (HttpServletResponse)res.raw(), (Throwable)error);
                    this.handler.handleSend(response, span);
                    req.raw().removeAttribute(Span.class.getName());
                    ((CurrentTraceContext.Scope)req.attribute(CurrentTraceContext.Scope.class.getName())).close();
                }
            }
        };
    }
}

