/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.MessageConsumerRequest;
import brave.spring.rabbit.SpringRabbitTracing;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class TracingRabbitListenerAdvice
implements MethodInterceptor {
    final SpringRabbitTracing springRabbitTracing;
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<MessageConsumerRequest> extractor;
    final TraceContext.Injector<MessageConsumerRequest> injector;
    final SamplerFunction<MessagingRequest> sampler;
    @Nullable
    final String remoteServiceName;

    TracingRabbitListenerAdvice(SpringRabbitTracing springRabbitTracing) {
        this.springRabbitTracing = springRabbitTracing;
        this.tracing = springRabbitTracing.tracing;
        this.tracer = this.tracing.tracer();
        this.extractor = springRabbitTracing.consumerExtractor;
        this.sampler = springRabbitTracing.consumerSampler;
        this.injector = springRabbitTracing.consumerInjector;
        this.remoteServiceName = springRabbitTracing.remoteServiceName;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Message message = (Message)methodInvocation.getArguments()[1];
        MessageConsumerRequest request = new MessageConsumerRequest(message);
        TraceContextOrSamplingFlags extracted = this.springRabbitTracing.extractAndClearHeaders(this.extractor, request, message);
        Span consumerSpan = this.springRabbitTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted);
        Span listenerSpan = this.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            this.setConsumerSpan(consumerSpan, message.getMessageProperties());
            long timestamp = this.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(listenerSpan);
        Throwable error = null;
        try {
            Object consumerFinish = methodInvocation.proceed();
            return consumerFinish;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (error != null) {
                listenerSpan.error(error);
            }
            listenerSpan.finish();
            ws.close();
        }
    }

    void setConsumerSpan(Span span, MessageProperties properties) {
        span.name("next-message").kind(Span.Kind.CONSUMER);
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.exchange", properties.getReceivedExchange());
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.routing_key", properties.getReceivedRoutingKey());
        TracingRabbitListenerAdvice.maybeTag(span, "rabbit.queue", properties.getConsumerQueue());
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
    }

    static void maybeTag(Span span, String tag, String value) {
        if (value != null) {
            span.tag(tag, value);
        }
    }
}

