/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;

final class TracingMessagePostProcessor
implements MessagePostProcessor {
    static final Propagation.Setter<MessageProperties, String> SETTER = new Propagation.Setter<MessageProperties, String>(){

        public void put(MessageProperties carrier, String key, String value) {
            carrier.setHeader(key, (Object)value);
        }

        public String toString() {
            return "MessageProperties::setHeader";
        }
    };
    final TraceContext.Injector<MessageProperties> injector;
    final Tracer tracer;
    @Nullable
    final String remoteServiceName;

    TracingMessagePostProcessor(Tracing tracing, @Nullable String remoteServiceName) {
        this.injector = tracing.propagation().injector(SETTER);
        this.tracer = tracing.tracer();
        this.remoteServiceName = remoteServiceName;
    }

    public Message postProcessMessage(Message message) {
        Span span = this.tracer.nextSpan().kind(Span.Kind.PRODUCER).name("publish");
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
        this.injector.inject(span.context(), (Object)message.getMessageProperties());
        span.start().finish();
        return message;
    }
}

