/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.SpanCustomizer;
import brave.spring.webmvc.HandlerParser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public final class SpanCustomizingHandlerInterceptor
implements HandlerInterceptor {
    static final String BEST_MATCHING_PATTERN_ATTRIBUTE = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";
    @Autowired(required=false)
    HandlerParser handlerParser = new HandlerParser();

    SpanCustomizingHandlerInterceptor() {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        SpanCustomizer span = (SpanCustomizer)request.getAttribute(SpanCustomizer.class.getName());
        if (span != null) {
            SpanCustomizingHandlerInterceptor.setHttpRouteAttribute(request);
            this.handlerParser.preHandle(request, o, span);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }

    static void setHttpRouteAttribute(HttpServletRequest request) {
        Object httpRoute = request.getAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE);
        request.setAttribute("http.route", (Object)(httpRoute != null ? httpRoute.toString() : ""));
    }
}

