/*
 * Decompiled with CFR 0.152.
 */
package brave.test;

import brave.Tracing;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.internal.InternalPropagation;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.StrictCurrentTraceContext;
import brave.propagation.StrictScopeDecorator;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.test.IntegrationTestSpanHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public abstract class ITRemote {
    public static final BaggageField BAGGAGE_FIELD;
    public static final String BAGGAGE_FIELD_KEY = "user_id";
    @Rule
    public TestRule globalTimeout = new DisableOnDebug((TestRule)Timeout.seconds((long)20L));
    @Rule
    public IntegrationTestSpanHandler testSpanHandler = new IntegrationTestSpanHandler();
    @Rule
    public TestName testName = new TestName();
    protected final CurrentTraceContext currentTraceContext;
    protected final Propagation.Factory propagationFactory;
    protected Tracing tracing;
    final Closeable checkForLeakedScopes;

    protected TraceContext newTraceContext(SamplingFlags flags) {
        long id = System.nanoTime();
        TraceContext context = InternalPropagation.instance.newTraceContext(InternalPropagation.instance.flags(flags) | 0x40, 0L, id + 1L, id + 3L, id + 2L, id + 3L, Collections.emptyList());
        return this.propagationFactory.decorate(context);
    }

    protected CurrentTraceContext.Builder currentTraceContextBuilder() {
        return StrictCurrentTraceContext.newBuilder();
    }

    protected ITRemote() {
        CurrentTraceContext.Builder currentTraceContextBuilder = this.currentTraceContextBuilder();
        if (currentTraceContextBuilder instanceof StrictCurrentTraceContext.Builder) {
            this.currentTraceContext = currentTraceContextBuilder.build();
            this.checkForLeakedScopes = (Closeable)this.currentTraceContext;
        } else {
            StrictScopeDecorator strictScopeDecorator = StrictScopeDecorator.create();
            this.currentTraceContext = currentTraceContextBuilder.addScopeDecorator((CurrentTraceContext.ScopeDecorator)strictScopeDecorator).build();
            this.checkForLeakedScopes = strictScopeDecorator;
        }
        this.propagationFactory = BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY).add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BAGGAGE_FIELD).addKeyName(BAGGAGE_FIELD_KEY).build()).build();
        this.tracing = this.tracingBuilder(Sampler.ALWAYS_SAMPLE).build();
    }

    protected Tracing.Builder tracingBuilder(Sampler sampler) {
        return Tracing.newBuilder().localServiceName(this.getClass().getSimpleName()).localIp("127.0.0.1").addSpanHandler((SpanHandler)this.testSpanHandler).propagationFactory(this.propagationFactory).currentTraceContext(this.currentTraceContext).sampler(sampler);
    }

    @After
    public void close() throws Exception {
        Tracing current = Tracing.current();
        if (current != null) {
            current.close();
        }
        this.checkForLeakedScopes();
    }

    protected void checkForLeakedScopes() throws IOException {
        this.checkForLeakedScopes.close();
    }

    protected void assertSpanInInterval(MutableSpan span, long startTimestamp, long finishTimestamp) {
        ((AbstractLongAssert)Assertions.assertThat((long)span.startTimestamp()).withFailMessage("Expected %s to start after %s", new Object[]{span, startTimestamp})).isGreaterThanOrEqualTo(startTimestamp);
        ((AbstractLongAssert)Assertions.assertThat((long)span.finishTimestamp()).withFailMessage("Expected %s to finish after %s", new Object[]{span, finishTimestamp})).isLessThanOrEqualTo(finishTimestamp);
    }

    protected void assertSequential(MutableSpan span1, MutableSpan span2) {
        ((AbstractStringAssert)Assertions.assertThat((String)span1.id()).withFailMessage("Expected different span IDs: %s %s", new Object[]{span1, span2})).isNotEqualTo((Object)span2.id());
        ((AbstractLongAssert)Assertions.assertThat((long)span1.finishTimestamp()).withFailMessage("Expected %s to finish before %s started", new Object[]{span1, span2})).isLessThanOrEqualTo(span2.startTimestamp());
    }

    protected void assertSameIds(MutableSpan span, TraceContext parent) {
        ((AbstractStringAssert)Assertions.assertThat((String)span.traceId()).withFailMessage("Expected to have trace ID(%s): %s", new Object[]{parent.traceIdString(), span})).isEqualTo(parent.traceIdString());
        ((AbstractStringAssert)Assertions.assertThat((String)span.parentId()).withFailMessage("Expected to have parent ID(%s): %s", new Object[]{parent.parentIdString(), span})).isEqualTo(parent.parentIdString());
        ((AbstractStringAssert)Assertions.assertThat((String)span.id()).withFailMessage("Expected to have span ID(%s): %s", new Object[]{parent.spanIdString(), span})).isEqualTo(parent.spanIdString());
    }

    protected void assertChildOf(TraceContext child, TraceContext parent) {
        this.assertChildOf(new MutableSpan(child, null), parent);
    }

    protected void assertChildOf(MutableSpan child, TraceContext parent) {
        this.assertChildOf(child, new MutableSpan(parent, null));
    }

    protected void assertChildOf(MutableSpan child, MutableSpan parent) {
        ((AbstractStringAssert)Assertions.assertThat((String)child.traceId()).withFailMessage("Expected to have trace ID(%s): %s", new Object[]{parent.traceId(), child})).isEqualTo(parent.traceId());
        ((AbstractStringAssert)Assertions.assertThat((String)child.parentId()).withFailMessage("Expected to have parent ID(%s): %s", new Object[]{parent.id(), child})).isEqualTo(parent.id());
    }

    protected void assertNoError(MutableSpan result) {
        IntegrationTestSpanHandler.assertNoError(result);
    }

    protected void assertNoErrorTag(MutableSpan result) {
        IntegrationTestSpanHandler.assertNoErrorTag(result);
    }

    static {
        SamplingFlags.NOT_SAMPLED.toString();
        BAGGAGE_FIELD = BaggageField.create((String)"userId");
    }
}

