/*
 * Decompiled with CFR 0.152.
 */
package brave.test.propagation;

import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.CorrelationScopeConfig;
import brave.internal.Nullable;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.test.util.ClassLoaders;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.Test;

public abstract class CurrentTraceContextTest {
    protected static final CorrelationScopeConfig.SingleCorrelationField CORRELATION_FIELD = CorrelationScopeConfig.SingleCorrelationField.create((BaggageField)BaggageField.create((String)"userId"));
    Propagation.Factory baggageFactory = BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY).add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)CORRELATION_FIELD.baggageField())).build();
    protected final CurrentTraceContext currentTraceContext;
    protected final TraceContext context = this.baggageFactory.decorate(TraceContext.newBuilder().traceIdHigh(-1L).traceId(1L).spanId(1L).sampled(true).build());
    protected final TraceContext notYetSampledContext = TraceContext.newBuilder().traceId(2L).spanId(1L).build();
    protected final TraceContext unsampledContext = TraceContext.newBuilder().traceId(2L).spanId(2L).sampled(false).build();

    protected abstract Class<? extends Supplier<CurrentTraceContext.Builder>> builderSupplier();

    protected CurrentTraceContextTest() {
        this.currentTraceContext = this.newBuilder().build();
    }

    protected void verifyImplicitContext(@Nullable TraceContext context) {
    }

    private CurrentTraceContext.Builder newBuilder() {
        return ClassLoaders.newInstance(this.builderSupplier(), this.getClass().getClassLoader()).get();
    }

    @Test
    public void currentSpan_defaultsToNull() {
        Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
    }

    @Test
    public void newScope_retainsContext() {
        this.retainsContext(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_retainsContext() {
        this.retainsContext(this.currentTraceContext.maybeScope(this.context));
    }

    void retainsContext(CurrentTraceContext.Scope scope) {
        try {
            Assertions.assertThat((Object)scope).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void newScope_noticesDifferentBaggageField() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            TraceContext differentBaggageField = this.context.toBuilder().build();
            CORRELATION_FIELD.baggageField().updateValue(differentBaggageField, "foo");
            try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(differentBaggageField);){
                Assertions.assertThat((Object)scope2).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)differentBaggageField);
                this.verifyImplicitContext(differentBaggageField);
            }
        }
    }

    @Test
    public void ignoresNoopScopeDecorator() {
        CurrentTraceContext.ScopeDecorator one = (context, scope) -> scope;
        CurrentTraceContext shouldHaveOnlyOne = this.newBuilder().addScopeDecorator(CurrentTraceContext.ScopeDecorator.NOOP).addScopeDecorator(one).build();
        ((ObjectArrayAssert)Assertions.assertThat((Object)shouldHaveOnlyOne).extracting("scopeDecorators").asInstanceOf(InstanceOfAssertFactories.ARRAY)).doesNotContain(new Object[]{CurrentTraceContext.ScopeDecorator.NOOP});
    }

    @Test
    public void newScope_decoratesWithDifferentScope() {
        CurrentTraceContext.Scope differentScope = () -> {};
        CurrentTraceContext decoratesWithDifferentScope = this.newBuilder().addScopeDecorator((context, scope) -> differentScope).build();
        try (CurrentTraceContext.Scope scope2 = decoratesWithDifferentScope.newScope(this.context);){
            Assertions.assertThat((Object)scope2).isSameAs((Object)differentScope);
        }
        scope2 = decoratesWithDifferentScope.newScope(null);
        try {
            Assertions.assertThat((Object)scope2).isSameAs((Object)differentScope);
        }
        finally {
            if (scope2 != null) {
                scope2.close();
            }
        }
    }

    @Test
    public void maybeScope_decoratesWithDifferentScope() {
        CurrentTraceContext.Scope scope2;
        CurrentTraceContext.Scope differentScope = () -> {};
        CurrentTraceContext decoratesWithDifferentScope = this.newBuilder().addScopeDecorator((context, scope) -> differentScope).build();
        try (CurrentTraceContext.Scope noop = CurrentTraceContext.Scope.NOOP;){
            scope2 = decoratesWithDifferentScope.maybeScope(this.context);
            try {
                Assertions.assertThat((Object)scope2).isSameAs((Object)differentScope);
            }
            finally {
                if (scope2 != null) {
                    scope2.close();
                }
            }
        }
        noop = CurrentTraceContext.Scope.NOOP;
        try {
            scope2 = decoratesWithDifferentScope.maybeScope(null);
            try {
                Assertions.assertThat((Object)scope2).isSameAs((Object)differentScope);
            }
            finally {
                if (scope2 != null) {
                    scope2.close();
                }
            }
        }
        finally {
            if (noop != null) {
                noop.close();
            }
        }
    }

    @Test
    public void newScope_noticesDifferentSpanId() {
        this.noticesDifferentSpanId(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_noticesDifferentSpanId() {
        this.noticesDifferentSpanId(this.currentTraceContext.maybeScope(this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noticesDifferentSpanId(CurrentTraceContext.Scope scope) {
        TraceContext differentSpanId = this.context.toBuilder().spanId(this.context.spanId() + 1L).build();
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(differentSpanId);){
            Assertions.assertThat((Object)scope2).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)differentSpanId);
            this.verifyImplicitContext(differentSpanId);
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void newScope_noticesDifferentContext() {
        this.noticesDifferentContext(this.currentTraceContext.newScope(this.context));
    }

    @Test
    public void maybeScope_noticesDifferentContext() {
        this.noticesDifferentContext(this.currentTraceContext.maybeScope(this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noticesDifferentContext(CurrentTraceContext.Scope scope) {
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(this.unsampledContext);){
            Assertions.assertThat((Object)scope2).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.unsampledContext);
            this.verifyImplicitContext(this.unsampledContext);
            try (CurrentTraceContext.Scope scope3 = this.currentTraceContext.maybeScope(this.notYetSampledContext);){
                Assertions.assertThat((Object)scope3).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.notYetSampledContext);
                this.verifyImplicitContext(this.notYetSampledContext);
            }
        }
        finally {
            scope.close();
        }
    }

    @Test
    public void maybeScope_doesntDuplicateContext() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);
             CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(this.context);){
            Assertions.assertThat((Object)scope2).isEqualTo((Object)CurrentTraceContext.Scope.NOOP);
        }
    }

    @Test
    public void newScope_canClearScope() {
        this.canClearScope(() -> this.currentTraceContext.newScope(null));
    }

    @Test
    public void maybeScope_canClearScope() {
        this.canClearScope(() -> this.currentTraceContext.maybeScope(null));
    }

    @Test
    public void maybeScope_doesntDuplicateContext_onNull() {
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.maybeScope(null);){
            Assertions.assertThat((Object)scope2).isEqualTo((Object)CurrentTraceContext.Scope.NOOP);
        }
    }

    void canClearScope(Supplier<CurrentTraceContext.Scope> noScoper) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            try (CurrentTraceContext.Scope noScope = noScoper.get();){
                Assertions.assertThat((Object)noScope).isNotEqualTo((Object)CurrentTraceContext.Scope.NOOP);
                Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
                this.verifyImplicitContext(null);
            }
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    protected void is_inheritable(CurrentTraceContext inheritableCurrentTraceContext) throws Exception {
        ThreadPoolExecutor service = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try (CurrentTraceContext.Scope scope = inheritableCurrentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)inheritableCurrentTraceContext).get()).get()).isEqualTo((Object)this.context);
        }
        Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)inheritableCurrentTraceContext).get()).get()).isEqualTo((Object)this.context);
        service.shutdownNow();
    }

    @Test
    public void isnt_inheritable() throws Exception {
        ExecutorService service = Executors.newCachedThreadPool();
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> {
                this.verifyImplicitContext(null);
                return this.currentTraceContext.get();
            }).get()).isNull();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw (Exception)e.getCause();
        }
        Assertions.assertThat((Object)service.submit(() -> ((CurrentTraceContext)this.currentTraceContext).get()).get()).isNull();
        this.verifyImplicitContext(null);
        service.shutdownNow();
    }

    @Test
    public void attachesSpanInCallable_canClear() throws Exception {
        Callable callable = this.currentTraceContext.wrap(() -> {
            Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
            this.verifyImplicitContext(null);
            return true;
        });
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            callable.call();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void attachesSpanInCallable() throws Exception {
        Callable callable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            callable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
                return true;
            });
            callable.call();
        }
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            callable.call();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void restoresSpanAfterCallable() throws Exception {
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(this.context);){
            this.attachesSpanInCallable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    @Test
    public void attachesSpanInRunnable() {
        Runnable runnable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            runnable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
            });
            runnable.run();
        }
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.unsampledContext);){
            runnable.run();
            this.verifyImplicitContext(this.unsampledContext);
        }
    }

    @Test
    public void restoresSpanAfterRunnable() throws Exception {
        TraceContext context0 = TraceContext.newBuilder().traceId(3L).spanId(3L).build();
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(context0);){
            this.attachesSpanInRunnable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)context0);
            this.verifyImplicitContext(context0);
        }
    }

    @Test
    public void unloadable_unused() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(Unused.class, this.builderSupplier());
    }

    @Test
    public void unloadable_afterScopeClose() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(ClosedScope.class, this.builderSupplier());
    }

    @Test
    public void notUnloadable_whenScopeLeaked() {
        try {
            ClassLoaders.assertRunIsUnloadableWithSupplier(LeakedScope.class, this.builderSupplier());
            Assertions.failBecauseExceptionWasNotThrown(AssertionError.class);
        }
        catch (AssertionError e) {
            this.currentTraceContext.newScope(null);
        }
    }

    static class LeakedScope
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext.Builder> {
        LeakedScope() {
        }

        @Override
        public void accept(CurrentTraceContext.Builder builder) {
            builder.build().newScope(TraceContext.newBuilder().traceId(1L).spanId(2L).build());
        }
    }

    static class ClosedScope
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext.Builder> {
        ClosedScope() {
        }

        @Override
        public void accept(CurrentTraceContext.Builder builder) {
            CurrentTraceContext current = builder.build();
            CurrentTraceContext.Scope ws = current.newScope(TraceContext.newBuilder().traceId(1L).spanId(2L).build());
            if (ws != null) {
                ws.close();
            }
        }
    }

    static class Unused
    extends ClassLoaders.ConsumerRunnable<CurrentTraceContext.Builder> {
        Unused() {
        }

        @Override
        public void accept(CurrentTraceContext.Builder builder) {
            builder.build();
        }
    }
}

