/*
 * Decompiled with CFR 0.152.
 */
package brave.test;

import brave.Span;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.handler.OrphanTracker;
import brave.propagation.TraceContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class IntegrationTestSpanHandler
extends SpanHandler
implements TestRule {
    static final String ANY_STRING = ".+";
    final BlockingQueue<MutableSpan> spans = new LinkedBlockingQueue<MutableSpan>();
    final SpanHandler orphanTracker;
    boolean ignoreAnySpans;

    public IntegrationTestSpanHandler() {
        MutableSpan intentionallyWrongDefaultSpan = new MutableSpan();
        intentionallyWrongDefaultSpan.tag("not", "me");
        this.orphanTracker = OrphanTracker.newBuilder().defaultSpan(intentionallyWrongDefaultSpan).clock(Platform.get().clock()).logLevel(Level.WARNING).build();
    }

    public void ignoreAnySpans() {
        this.ignoreAnySpans = true;
    }

    void assertSpansConsumed() {
        if (this.ignoreAnySpans) {
            return;
        }
        try {
            MutableSpan span = this.spans.poll(100L, TimeUnit.MILLISECONDS);
            ((ObjectAssert)Assertions.assertThat((Object)span).withFailMessage("Span remaining in queue. Check for redundant reporting: %s", new Object[]{span})).isNull();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    public MutableSpan takeLocalSpan() {
        MutableSpan result = this.doTakeSpan(false);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)result.kind()).withFailMessage("Expected %s to have no kind", new Object[]{result})).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)result.remoteServiceName()).withFailMessage("Expected %s to have no remote endpoint", new Object[]{result})).isNull();
        return result;
    }

    MutableSpan doTakeSpan(boolean flushed) {
        MutableSpan result;
        try {
            result = this.spans.poll(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
        ((ObjectAssert)Assertions.assertThat((Object)result).withFailMessage("Timeout waiting for span", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.containsAnnotation("brave.flush")).withFailMessage("Orphaned span found: %s\nLook for code missing span.flush() or span.finish().", new Object[]{result})).isFalse();
        ((AbstractLongAssert)Assertions.assertThat((long)result.startTimestamp()).withFailMessage("Expected a startTimestamp: %s\nLook for code missing span.start().", new Object[]{result})).isNotZero();
        if (flushed) {
            ((AbstractLongAssert)Assertions.assertThat((long)result.finishTimestamp()).withFailMessage("Expected no finishTimestamp: %s", new Object[]{result})).isZero();
        } else {
            ((AbstractLongAssert)Assertions.assertThat((long)result.finishTimestamp()).withFailMessage("Expected a finishTimestamp: %s", new Object[]{result})).isNotZero();
        }
        return result;
    }

    public MutableSpan takeRemoteSpan(Span.Kind kind) {
        MutableSpan result = this.doTakeSpan(null, null, null, false);
        this.assertRemoteSpan(result, kind);
        return result;
    }

    public MutableSpan takeRemoteSpanWithError(Span.Kind kind, Throwable error) {
        MutableSpan result = this.doTakeSpan(error, null, null, false);
        this.assertRemoteSpan(result, kind);
        return result;
    }

    public MutableSpan takeRemoteSpanWithError(Span.Kind kind) {
        MutableSpan result = this.doTakeSpan(null, null, ANY_STRING, false);
        this.assertRemoteSpan(result, kind);
        return result;
    }

    public MutableSpan takeRemoteSpanWithErrorMessage(Span.Kind kind, String errorMessage) {
        MutableSpan result = this.doTakeSpan(null, errorMessage, null, false);
        this.assertRemoteSpan(result, kind);
        return result;
    }

    public MutableSpan takeRemoteSpanWithErrorTag(Span.Kind kind, String errorTag) {
        MutableSpan result = this.doTakeSpan(null, null, errorTag, false);
        this.assertRemoteSpan(result, kind);
        return result;
    }

    void assertRemoteSpan(MutableSpan span, Span.Kind kind) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)span.kind()).withFailMessage("Expected %s to have kind=%s", new Object[]{span, kind})).isEqualTo((Object)kind);
    }

    MutableSpan doTakeSpan(@Nullable Throwable error, @Nullable String errorMessage, @Nullable String errorTag, boolean flushed) {
        MutableSpan result = this.doTakeSpan(flushed);
        if (ANY_STRING.equals(errorTag)) {
            boolean hasError = result.error() != null || result.tag("error") != null;
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasError).withFailMessage("Expected %s to have an error, but there was no error", new Object[]{result})).isTrue();
        } else if (error != null) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result.error()).withFailMessage("Expected %s to have an error, but there was no error", new Object[]{result})).isNotNull();
            Assertions.assertThat((Throwable)result.error()).isEqualTo((Object)error);
            IntegrationTestSpanHandler.assertNoErrorTag(result);
        } else if (errorMessage != null) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result.error()).withFailMessage("Expected %s to have an error message matching [%s], but there was no error", new Object[]{result, errorMessage})).isNotNull();
            Pattern regex = Pattern.compile(errorMessage, 32);
            String actual = result.error().getMessage();
            ((AbstractStringAssert)Assertions.assertThat((String)actual).withFailMessage("Expected %s to have an error message matching [%s], but was [%s]", new Object[]{result, errorMessage, actual})).matches(regex);
            IntegrationTestSpanHandler.assertNoErrorTag(result);
        } else if (errorTag != null) {
            Pattern regex = Pattern.compile(errorTag, 32);
            ((AbstractStringAssert)Assertions.assertThat((String)((String)result.tags().get("error"))).withFailMessage("Expected %s to have an error tag matching %s", new Object[]{result, errorTag})).matches(regex);
        } else {
            IntegrationTestSpanHandler.assertNoError(result);
            IntegrationTestSpanHandler.assertNoErrorTag(result);
        }
        return result;
    }

    static void assertNoError(MutableSpan result) {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result.error()).withFailMessage("Expected %s to have no error", new Object[]{result})).isNull();
    }

    static void assertNoErrorTag(MutableSpan result) {
        ((AbstractStringAssert)Assertions.assertThat((String)((String)result.tags().get("error"))).withFailMessage("Expected %s to have no error tag", new Object[]{result})).isNull();
    }

    public boolean begin(TraceContext context, MutableSpan span, @Nullable TraceContext parent) {
        return this.orphanTracker.begin(context, span, parent);
    }

    public boolean handlesAbandoned() {
        return this.orphanTracker.handlesAbandoned();
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        this.orphanTracker.end(context, span, cause);
        this.spans.add(span);
        return true;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                    IntegrationTestSpanHandler.this.assertSpansConsumed();
                }
                finally {
                    IntegrationTestSpanHandler.this.spans.clear();
                }
            }
        };
    }

    public String toString() {
        return this.spans.toString();
    }
}

