/*
 * Decompiled with CFR 0.152.
 */
package brave.cassandra.driver;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.cassandra.driver.CassandraClientParser;
import brave.cassandra.driver.CassandraClientSampler;
import brave.cassandra.driver.CassandraClientTracing;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class TracingSession
extends AbstractSession {
    final Tracer tracer;
    final CassandraClientSampler sampler;
    final CassandraClientParser parser;
    final String remoteServiceName;
    final Session delegate;

    public static Session create(Tracing tracing, Session delegate) {
        return new TracingSession(CassandraClientTracing.create(tracing), delegate);
    }

    public static Session create(CassandraClientTracing cassandraTracing, Session delegate) {
        ProtocolVersion version = delegate.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        if (version.compareTo((Enum)ProtocolVersion.V4) >= 0 && cassandraTracing.propagationEnabled()) {
            return new PropagatingTracingSession(cassandraTracing, delegate);
        }
        return new TracingSession(cassandraTracing, delegate);
    }

    TracingSession(CassandraClientTracing cassandraTracing, Session target) {
        if (cassandraTracing == null) {
            throw new NullPointerException("cassandraTracing == null");
        }
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        this.delegate = target;
        this.tracer = cassandraTracing.tracing().tracer();
        this.sampler = cassandraTracing.sampler();
        this.parser = cassandraTracing.parser();
        String remoteServiceName = cassandraTracing.remoteServiceName();
        this.remoteServiceName = remoteServiceName != null ? remoteServiceName : target.getCluster().getClusterName();
    }

    public ResultSetFuture executeAsync(Statement statement) {
        ResultSetFuture result;
        final Span span = this.nextSpan(statement);
        if (!span.isNoop()) {
            this.parser.request(statement, (SpanCustomizer)span.kind(Span.Kind.CLIENT));
        }
        this.maybeDecorate(statement, span);
        span.start();
        try {
            result = this.delegate.executeAsync(statement);
        }
        catch (Error | RuntimeException e) {
            if (span.isNoop()) {
                throw e;
            }
            span.error(e);
            span.finish();
            throw e;
        }
        if (span.isNoop()) {
            return result;
        }
        Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                InetSocketAddress host = result.getExecutionInfo().getQueriedHost().getSocketAddress();
                span.remoteIpAndPort(host.getHostString(), host.getPort());
                span.remoteServiceName(TracingSession.this.remoteServiceName);
                TracingSession.this.parser.response(result, (SpanCustomizer)span);
                span.finish();
            }

            public void onFailure(Throwable e) {
                span.error(e);
                span.finish();
            }
        });
        return result;
    }

    void maybeDecorate(Statement statement, Span span) {
    }

    Span nextSpan(Statement statement) {
        if (this.tracer.currentSpan() != null) {
            return this.tracer.nextSpan();
        }
        Boolean sampled = this.sampler.trySample(statement);
        if (sampled == null) {
            return this.tracer.newTrace();
        }
        return this.tracer.withSampler(sampled != false ? Sampler.ALWAYS_SAMPLE : Sampler.NEVER_SAMPLE).nextSpan();
    }

    protected ListenableFuture<PreparedStatement> prepareAsync(String query, Map<String, ByteBuffer> customPayload) {
        SimpleStatement statement = new SimpleStatement(query);
        statement.setOutgoingPayload(customPayload);
        return this.prepareAsync((RegularStatement)statement);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.delegate.prepareAsync(query);
    }

    public String getLoggedKeyspace() {
        return this.delegate.getLoggedKeyspace();
    }

    public Session init() {
        return this.delegate.init();
    }

    public ListenableFuture<Session> initAsync() {
        return this.delegate.initAsync();
    }

    public ListenableFuture<PreparedStatement> prepareAsync(RegularStatement statement) {
        return this.delegate.prepareAsync(statement);
    }

    public CloseFuture closeAsync() {
        return this.delegate.closeAsync();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public Cluster getCluster() {
        return this.delegate.getCluster();
    }

    public Session.State getState() {
        return this.delegate.getState();
    }

    static final class PropagatingTracingSession
    extends TracingSession {
        PropagatingTracingSession(CassandraClientTracing cassandraTracing, Session target) {
            super(cassandraTracing, target);
        }

        @Override
        void maybeDecorate(Statement statement, Span span) {
            statement.enableTracing();
            LinkedHashMap<String, ByteBuffer> payload = new LinkedHashMap<String, ByteBuffer>();
            if (statement.getOutgoingPayload() != null) {
                payload.putAll(statement.getOutgoingPayload());
            }
            payload.put("b3", ByteBuffer.wrap(B3SingleFormat.writeB3SingleFormatAsBytes((TraceContext)span.context())));
            statement.setOutgoingPayload(payload);
        }
    }
}

