/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.tracecontext;

import brave.propagation.tracecontext.TraceContextPropagation;
import brave.propagation.tracecontext.internal.CharSequences;
import brave.propagation.tracecontext.internal.codec.EntrySplitter;

final class TracestateFormat
implements EntrySplitter.Handler<int[]> {
    static final TracestateFormat INSTANCE;
    final String thisKey;
    final boolean shouldThrow;
    final EntrySplitter entrySplitter;
    static final int LAST_VALID_KEY_CHAR = 122;
    static final boolean[] VALID_KEY_CHARS;
    static final int LAST_VALID_VALUE_CHAR = 126;
    static final boolean[] VALID_VALUE_CHARS;

    static TracestateFormat get() {
        return INSTANCE;
    }

    TracestateFormat(String thisKey, boolean shouldThrow) {
        this.thisKey = thisKey;
        this.shouldThrow = shouldThrow;
        this.entrySplitter = EntrySplitter.newBuilder().maxEntries(32).entrySeparator(',').trimOWSAroundEntrySeparator(true).keyValueSeparator('=').trimOWSAroundKeyValueSeparator(false).shouldThrow(shouldThrow).build();
    }

    static boolean isValidTracestateKeyChar(char c) {
        return TracestateFormat.isLetterOrNumber(c) || c == '@' || c == '_' || c == '-' || c == '*' || c == '/';
    }

    static boolean isLetterOrNumber(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static boolean isValidTracestateValueChar(char c) {
        return c >= ' ' && c <= '~' && c != ',' && c != '=';
    }

    @Override
    public boolean onEntry(int[] target, CharSequence buffer, int beginKey, int endKey, int beginValue, int endValue) {
        if (!this.validateKey(buffer, beginKey, endKey) || !this.validateValue(buffer, beginValue, endValue)) {
            return false;
        }
        if (CharSequences.regionMatches(this.thisKey, buffer, beginKey, endKey)) {
            target[1] = beginKey;
            target[2] = endKey;
            target[3] = beginValue;
            target[4] = endValue;
        } else if (target[1] != -1 && target[5] == -1) {
            target[5] = beginKey;
        } else if (target[0] == -1) {
            target[0] = endValue;
        }
        return true;
    }

    boolean parseInto(String tracestateString, int[] indices) {
        return this.entrySplitter.parse(this, indices, tracestateString);
    }

    boolean validateKey(CharSequence buffer, int beginKey, int endKey) {
        int length = endKey - beginKey;
        if (length == 0) {
            return TraceContextPropagation.logOrThrow("Invalid key: empty", this.shouldThrow);
        }
        if (length > 256) {
            return TraceContextPropagation.logOrThrow("Invalid key: too large", this.shouldThrow);
        }
        char first = buffer.charAt(beginKey);
        if (!TracestateFormat.isLetterOrNumber(first)) {
            return TraceContextPropagation.logOrThrow("Invalid key: must start with a-z 0-9", this.shouldThrow);
        }
        for (int i = beginKey + 1; i < endKey; ++i) {
            char c = buffer.charAt(i);
            if (c <= 'z' && VALID_KEY_CHARS[c]) continue;
            return TraceContextPropagation.logOrThrow("Invalid key: valid characters are: a-z 0-9 _ - * / @", this.shouldThrow);
        }
        return true;
    }

    boolean validateValue(CharSequence buffer, int beginValue, int endValue) {
        int length = endValue - beginValue;
        if (length == 0) {
            return TraceContextPropagation.logOrThrow("Invalid value: empty", this.shouldThrow);
        }
        if (length > 256) {
            return TraceContextPropagation.logOrThrow("Invalid value: too large", this.shouldThrow);
        }
        if (buffer.charAt(endValue - 1) == ' ') {
            return TraceContextPropagation.logOrThrow("Invalid value: must end in a non-space character", this.shouldThrow);
        }
        for (int i = beginValue; i < endValue; ++i) {
            char c = buffer.charAt(i);
            if (c <= '~' && VALID_VALUE_CHARS[c]) continue;
            return TraceContextPropagation.logOrThrow("Invalid value: valid characters are: ' ' to '~', except ',' and '='", this.shouldThrow);
        }
        return true;
    }

    static {
        char c;
        INSTANCE = new TracestateFormat("b3", false);
        VALID_KEY_CHARS = new boolean[123];
        VALID_VALUE_CHARS = new boolean[127];
        for (c = '\u0000'; c < VALID_KEY_CHARS.length; c = (char)(c + '\u0001')) {
            TracestateFormat.VALID_KEY_CHARS[c] = TracestateFormat.isValidTracestateKeyChar(c);
        }
        for (c = '\u0000'; c < VALID_VALUE_CHARS.length; c = (char)(c + '\u0001')) {
            TracestateFormat.VALID_VALUE_CHARS[c] = TracestateFormat.isValidTracestateValueChar(c);
        }
    }
}

