/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.TraceServiceGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Empty;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.List;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;
import zipkin2.reporter.stackdriver.internal.UnaryClientCall;

public final class StackdriverSender
extends Sender {
    static final ByteString SPAN_ID_PREFIX = ByteString.copyFromUtf8((String)"/spans/");
    final Channel channel;
    final CallOptions callOptions;
    final ByteString projectName;
    final ByteString traceIdPrefix;
    final boolean shutdownChannelOnClose;
    final int projectNameFieldSize;
    final int spanNameSize;
    final int spanNameFieldSize;
    final long serverResponseTimeoutMs;
    final BatchWriteSpansCall healthcheckCall;
    volatile boolean closeCalled;

    public static Builder newBuilder() {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"cloudtrace.googleapis.com").build();
        Builder result = StackdriverSender.newBuilder((Channel)channel);
        result.shutdownChannelOnClose = true;
        return result;
    }

    public static Builder newBuilder(Channel channel) {
        return new Builder(channel);
    }

    StackdriverSender(Builder builder) {
        this.channel = builder.channel;
        this.callOptions = builder.callOptions;
        this.projectName = ByteString.copyFromUtf8((String)("projects/" + builder.projectId));
        this.serverResponseTimeoutMs = builder.serverResponseTimeoutMs;
        this.traceIdPrefix = this.projectName.concat(ByteString.copyFromUtf8((String)"/traces/"));
        this.shutdownChannelOnClose = builder.shutdownChannelOnClose;
        this.projectNameFieldSize = CodedOutputStream.computeBytesSize((int)1, (ByteString)this.projectName);
        this.spanNameSize = this.traceIdPrefix.size() + 32 + SPAN_ID_PREFIX.size() + 16;
        this.spanNameFieldSize = CodedOutputStream.computeTagSize((int)1) + CodedOutputStream.computeUInt32SizeNoTag((int)this.spanNameSize) + this.spanNameSize;
        BatchWriteSpansRequest healthcheckRequest = BatchWriteSpansRequest.newBuilder().setNameBytes(this.projectName).addSpans(Span.newBuilder().build()).build();
        this.healthcheckCall = new BatchWriteSpansCall(healthcheckRequest);
    }

    public Encoding encoding() {
        return Encoding.PROTO3;
    }

    public int messageMaxBytes() {
        return 0x100000;
    }

    public int messageSizeInBytes(List<byte[]> traceIdPrefixedSpans) {
        int length = traceIdPrefixedSpans.size();
        if (length == 0) {
            return 0;
        }
        if (length == 1) {
            return this.messageSizeInBytes(traceIdPrefixedSpans.get(0).length);
        }
        int size = this.projectNameFieldSize;
        for (int i = 0; i < length; ++i) {
            size += this.spanFieldSize(traceIdPrefixedSpans.get(i).length);
        }
        return size;
    }

    public int messageSizeInBytes(int traceIdPrefixedSpanSize) {
        return this.projectNameFieldSize + this.spanFieldSize(traceIdPrefixedSpanSize);
    }

    public Call<Void> sendSpans(List<byte[]> traceIdPrefixedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        int length = traceIdPrefixedSpans.size();
        if (length == 0) {
            return Call.create(null);
        }
        BatchWriteSpansRequest.Builder request = BatchWriteSpansRequest.newBuilder().setNameBytes(this.projectName);
        for (byte[] traceIdPrefixedSpan : traceIdPrefixedSpans) {
            request.addSpans(StackdriverSender.parseTraceIdPrefixedSpan(traceIdPrefixedSpan, this.spanNameSize, this.traceIdPrefix));
        }
        return new BatchWriteSpansCall(request.build()).map(EmptyToVoid.INSTANCE);
    }

    public CheckResult check() {
        try {
            this.healthcheckCall.clone().execute();
        }
        catch (StatusRuntimeException sre) {
            if (sre.getStatus().getCode() == Status.Code.INVALID_ARGUMENT) {
                return CheckResult.OK;
            }
            return CheckResult.failed((Throwable)sre);
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
        return CheckResult.OK;
    }

    public final String toString() {
        return "StackdriverSender{" + this.projectName.toStringUtf8() + "}";
    }

    public void close() {
        if (!this.shutdownChannelOnClose) {
            return;
        }
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        ((ManagedChannel)this.channel).shutdownNow();
    }

    static Span parseTraceIdPrefixedSpan(byte[] traceIdPrefixedSpan, int spanNameSize, ByteString traceIdPrefix) {
        int off = 32;
        int len = traceIdPrefixedSpan.length - off;
        Span.Builder span = Span.newBuilder();
        try {
            span.mergeFrom(traceIdPrefixedSpan, off, len);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        int offset = 0;
        byte[] spanName = new byte[spanNameSize];
        traceIdPrefix.copyTo(spanName, offset);
        System.arraycopy(traceIdPrefixedSpan, 0, spanName, offset += traceIdPrefix.size(), 32);
        SPAN_ID_PREFIX.copyTo(spanName, offset += 32);
        span.getSpanIdBytes().copyTo(spanName, offset += SPAN_ID_PREFIX.size());
        span.setNameBytes(UnsafeByteOperations.unsafeWrap((byte[])spanName));
        return span.build();
    }

    int spanFieldSize(int traceIdPrefixedSpanSize) {
        int sizeOfSpanMessage = traceIdPrefixedSpanSize - 32 + this.spanNameFieldSize;
        return CodedOutputStream.computeTagSize((int)2) + CodedOutputStream.computeUInt32SizeNoTag((int)sizeOfSpanMessage) + sizeOfSpanMessage;
    }

    public static final class Builder {
        final Channel channel;
        String projectId;
        CallOptions callOptions = CallOptions.DEFAULT;
        boolean shutdownChannelOnClose;
        long serverResponseTimeoutMs = 5000L;

        Builder(Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel == null");
            }
            this.channel = channel;
        }

        public Builder projectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("projectId == null");
            }
            this.projectId = projectId;
            return this;
        }

        public Builder callOptions(CallOptions callOptions) {
            if (callOptions == null) {
                throw new NullPointerException("callOptions == null");
            }
            this.callOptions = callOptions;
            return this;
        }

        public Builder serverResponseTimeoutMs(long serverResponseTimeoutMs) {
            if (serverResponseTimeoutMs <= 0L) {
                throw new IllegalArgumentException("Server response timeout must be greater than 0");
            }
            this.serverResponseTimeoutMs = serverResponseTimeoutMs;
            return this;
        }

        public StackdriverSender build() {
            if (this.projectId == null) {
                throw new NullPointerException("projectId == null");
            }
            return new StackdriverSender(this);
        }
    }

    final class BatchWriteSpansCall
    extends UnaryClientCall<BatchWriteSpansRequest, Empty> {
        BatchWriteSpansCall(BatchWriteSpansRequest request) {
            super(StackdriverSender.this.channel, TraceServiceGrpc.getBatchWriteSpansMethod(), StackdriverSender.this.callOptions, request, StackdriverSender.this.serverResponseTimeoutMs);
        }

        public String toString() {
            return "BatchWriteSpansCall{" + this.request() + "}";
        }

        public BatchWriteSpansCall clone() {
            return new BatchWriteSpansCall((BatchWriteSpansRequest)this.request());
        }
    }

    static enum EmptyToVoid implements Call.Mapper<Empty, Void>
    {
        INSTANCE{

            public Void map(Empty empty) {
                return null;
            }
        };

    }
}

