/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.internal;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.reporter.stackdriver.internal.AwaitableUnaryClientCallListener;
import zipkin2.reporter.stackdriver.internal.CallbackToUnaryClientCallListener;

public abstract class UnaryClientCall<ReqT, RespT>
extends Call.Base<RespT> {
    public static final int DEFAULT_SERVER_TIMEOUT_MS = 5000;
    final ClientCall<ReqT, RespT> call;
    final ReqT request;
    final long serverTimeoutMs;

    protected UnaryClientCall(Channel channel, MethodDescriptor<ReqT, RespT> descriptor, CallOptions callOptions, ReqT request, long serverTimeoutMs) {
        this.call = channel.newCall(descriptor, callOptions);
        this.request = request;
        this.serverTimeoutMs = serverTimeoutMs;
    }

    protected final ReqT request() {
        return this.request;
    }

    protected final RespT doExecute() throws IOException {
        AwaitableUnaryClientCallListener listener = new AwaitableUnaryClientCallListener(this.serverTimeoutMs);
        this.beginUnaryCall(listener);
        return (RespT)listener.await();
    }

    protected final void doEnqueue(Callback<RespT> callback) {
        CallbackToUnaryClientCallListener<RespT> listener = new CallbackToUnaryClientCallListener<RespT>(callback);
        try {
            this.beginUnaryCall(listener);
        }
        catch (Error | RuntimeException t) {
            callback.onError(t);
            throw t;
        }
    }

    void beginUnaryCall(ClientCall.Listener<RespT> listener) {
        try {
            this.call.start(listener, new Metadata());
            this.call.request(1);
            this.call.sendMessage(this.request);
            this.call.halfClose();
        }
        catch (Error | RuntimeException t) {
            this.call.cancel(null, t);
            throw t;
        }
    }

    protected final void doCancel() {
        this.call.cancel(null, null);
    }
}

