/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.translation.stackdriver;

import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.Span;
import java.util.Map;
import zipkin2.Span;
import zipkin2.translation.stackdriver.SpanUtil;

final class AttributesExtractor {
    private static final String kAgentLabelKey = "/agent";
    private static final String kComponentLabelKey = "/component";
    private static final String kKindLabelKey = "/kind";
    private final Map<String, String> renamedLabels;

    AttributesExtractor(Map<String, String> renamedLabels) {
        this.renamedLabels = renamedLabels;
    }

    Span.Attributes extract(Span zipkinSpan) {
        Span.Attributes.Builder attributes = Span.Attributes.newBuilder();
        if (zipkinSpan.kind() != null) {
            attributes.putAttributeMap(kKindLabelKey, AttributesExtractor.toAttributeValue(this.kindLabel(zipkinSpan.kind())));
        }
        for (Map.Entry tag : zipkinSpan.tags().entrySet()) {
            attributes.putAttributeMap(this.getLabelName((String)tag.getKey()), AttributesExtractor.toAttributeValue((String)tag.getValue()));
        }
        if (zipkinSpan.localEndpoint() != null && zipkinSpan.kind() == Span.Kind.SERVER) {
            if (zipkinSpan.localEndpoint().ipv4() != null) {
                attributes.putAttributeMap(this.getLabelName("endpoint.ipv4"), AttributesExtractor.toAttributeValue(zipkinSpan.localEndpoint().ipv4()));
            }
            if (zipkinSpan.localEndpoint().ipv6() != null) {
                attributes.putAttributeMap(this.getLabelName("endpoint.ipv6"), AttributesExtractor.toAttributeValue(zipkinSpan.localEndpoint().ipv6()));
            }
        }
        if (zipkinSpan.localEndpoint() != null && zipkinSpan.localEndpoint().serviceName() != null && !zipkinSpan.localEndpoint().serviceName().isEmpty()) {
            attributes.putAttributeMap(kComponentLabelKey, AttributesExtractor.toAttributeValue(zipkinSpan.localEndpoint().serviceName()));
        }
        if (zipkinSpan.parentId() == null) {
            String agentName = System.getProperty("stackdriver.trace.zipkin.agent", "zipkin-java");
            attributes.putAttributeMap(kAgentLabelKey, AttributesExtractor.toAttributeValue(agentName));
        }
        return attributes.build();
    }

    static AttributeValue toAttributeValue(String text) {
        return AttributeValue.newBuilder().setStringValue(SpanUtil.toTruncatableString(text)).build();
    }

    private String getLabelName(String zipkinName) {
        String renamed = this.renamedLabels.get(zipkinName);
        return renamed != null ? renamed : zipkinName;
    }

    private String kindLabel(Span.Kind kind) {
        switch (kind) {
            case CLIENT: {
                return "client";
            }
            case SERVER: {
                return "server";
            }
            case PRODUCER: {
                return "producer";
            }
            case CONSUMER: {
                return "consumer";
            }
        }
        return kind.name().toLowerCase();
    }
}

