/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.collector.kafka;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.collector.kafka.KafkaCollector;

@ConfigurationProperties(value="zipkin.collector.kafka")
class ZipkinKafkaCollectorProperties {
    private String bootstrapServers;
    private String groupId;
    private String topic;
    private Integer streams;
    private Map<String, String> overrides = new LinkedHashMap<String, String>();

    ZipkinKafkaCollectorProperties() {
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = ZipkinKafkaCollectorProperties.emptyToNull(bootstrapServers);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = ZipkinKafkaCollectorProperties.emptyToNull(groupId);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = ZipkinKafkaCollectorProperties.emptyToNull(topic);
    }

    public Integer getStreams() {
        return this.streams;
    }

    public void setStreams(Integer streams) {
        this.streams = streams;
    }

    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, String> overrides) {
        this.overrides = overrides;
    }

    public KafkaCollector.Builder toBuilder() {
        KafkaCollector.Builder result = KafkaCollector.builder();
        if (this.bootstrapServers != null) {
            result.bootstrapServers(this.bootstrapServers);
        }
        if (this.groupId != null) {
            result.groupId(this.groupId);
        }
        if (this.topic != null) {
            result.topic(this.topic);
        }
        if (this.streams != null) {
            result.streams(this.streams.intValue());
        }
        if (this.overrides != null) {
            result.overrides(this.overrides);
        }
        return result;
    }

    private static String emptyToNull(String s) {
        return "".equals(s) ? null : s;
    }
}

