/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
class ZipkinPrometheusMetricsAutoConfiguration {
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_TRACE_V1 = Tag.of((String)"uri", (String)"/api/v1/trace/{traceId}");
    private static final Tag URI_TRACE_V2 = Tag.of((String)"uri", (String)"/api/v2/trace/{traceId}");
    private static final Tag URI_CROSSROADS = Tag.of((String)"uri", (String)"/zipkin/index.html");
    final PrometheusMeterRegistry registry;
    final String metricName;

    ZipkinPrometheusMetricsAutoConfiguration(PrometheusMeterRegistry registry, @Value(value="${management.metrics.web.server.requests-metric-name:http.server.requests}") String metricName) {
        this.registry = registry;
        this.metricName = metricName;
    }

    @Bean
    @Qualifier(value="httpRequestDurationCustomizer")
    UndertowDeploymentInfoCustomizer httpRequestDurationCustomizer() {
        HttpRequestDurationHandler.Wrapper result = new HttpRequestDurationHandler.Wrapper((MeterRegistry)this.registry, this.metricName);
        return info -> info.addInitialHandlerChainWrapper((HandlerWrapper)result);
    }

    static final class HttpRequestDurationHandler
    implements HttpHandler {
        final MeterRegistry registry;
        final String metricName;
        final HttpHandler next;
        final Clock clock;

        HttpRequestDurationHandler(MeterRegistry registry, String metricName, HttpHandler next) {
            this.registry = registry;
            this.metricName = metricName;
            this.next = next;
            this.clock = registry.config().clock();
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            long startTime = this.clock.monotonicTime();
            if (!exchange.isComplete()) {
                exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                    this.getTimeBuilder(exchange).register(this.registry).record(this.clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
                    nextListener.proceed();
                });
            }
            this.next.handleRequest(exchange);
        }

        private Timer.Builder getTimeBuilder(HttpServerExchange exchange) {
            return Timer.builder((String)this.metricName).tags(this.getTags(exchange)).description("Response time histogram").publishPercentileHistogram();
        }

        private Iterable<Tag> getTags(HttpServerExchange exchange) {
            return Arrays.asList(Tag.of((String)"method", (String)exchange.getRequestMethod().toString()), HttpRequestDurationHandler.uri(exchange), Tag.of((String)"status", (String)Integer.toString(exchange.getStatusCode())));
        }

        private static Tag uri(HttpServerExchange exchange) {
            int status = exchange.getStatusCode();
            if (status > 299 && status < 400) {
                return URI_REDIRECTION;
            }
            if (status == 404) {
                return URI_NOT_FOUND;
            }
            String uri = HttpRequestDurationHandler.getPathInfo(exchange);
            if (uri.startsWith("/zipkin")) {
                if (uri.equals("/zipkin/") || uri.equals("/zipkin") || uri.startsWith("/zipkin/traces/") || uri.equals("/zipkin/dependency") || uri.equals("/zipkin/traceViewer")) {
                    return URI_CROSSROADS;
                }
                if (uri.startsWith("/zipkin/api")) {
                    uri = uri.replaceFirst("/zipkin", "");
                }
            }
            if (uri.startsWith("/api/v1/trace/")) {
                return URI_TRACE_V1;
            }
            if (uri.startsWith("/api/v2/trace/")) {
                return URI_TRACE_V2;
            }
            return Tag.of((String)"uri", (String)uri);
        }

        private static String getPathInfo(HttpServerExchange exchange) {
            String uri = exchange.getRelativePath();
            if (!StringUtils.hasText((String)uri)) {
                return "/";
            }
            return uri.replaceAll("//+", "/").replaceAll("/$", "");
        }

        static final class Wrapper
        implements HandlerWrapper {
            final MeterRegistry registry;
            final String metricName;

            Wrapper(MeterRegistry registry, String metricName) {
                this.registry = registry;
                this.metricName = metricName;
            }

            public HttpHandler wrap(HttpHandler next) {
                return new HttpRequestDurationHandler(this.registry, this.metricName, next);
            }
        }
    }
}

