/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.storage.cassandra;

import brave.Tracing;
import brave.cassandra.driver.TracingSession;
import com.datastax.driver.core.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import zipkin2.storage.cassandra.v1.SessionFactory;

@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra")
@Configuration
class TracingZipkinCassandraStorageAutoConfiguration {
    final SessionFactory delegate = new SessionFactory.Default();
    @Autowired
    @Lazy
    Tracing tracing;

    TracingZipkinCassandraStorageAutoConfiguration() {
    }

    @Bean
    SessionFactory tracingSessionFactory() {
        return storage -> TracingSession.create((Tracing)this.tracing, (Session)this.delegate.create(storage));
    }
}

