/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.storage.cassandra;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.autoconfigure.storage.cassandra.ZipkinCassandraStorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.cassandra.v1.CassandraStorage;
import zipkin2.storage.cassandra.v1.SessionFactory;

@Configuration
@EnableConfigurationProperties(value={ZipkinCassandraStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra")
@ConditionalOnMissingBean(value={StorageComponent.class})
class ZipkinCassandraStorageAutoConfiguration {
    @Autowired(required=false)
    @Qualifier(value="tracingSessionFactory")
    SessionFactory tracingSessionFactory;

    ZipkinCassandraStorageAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinCassandraStorageProperties properties, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        CassandraStorage.Builder builder = properties.toBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality);
        return this.tracingSessionFactory == null ? builder.build() : builder.sessionFactory(this.tracingSessionFactory).build();
    }
}

