/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.http;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
class ZipkinElasticsearchOkHttpAutoConfiguration {
    @Autowired(required=false)
    @Qualifier(value="zipkinElasticsearchHttp")
    List<Interceptor> networkInterceptors = Collections.emptyList();
    @Autowired(required=false)
    @Qualifier(value="zipkinElasticsearchHttp")
    OkHttpClient.Builder elasticsearchOkHttpClientBuilder;

    ZipkinElasticsearchOkHttpAutoConfiguration() {
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @ConditionalOnMissingBean
    OkHttpClient elasticsearchOkHttpClient(@Value(value="${zipkin.storage.elasticsearch.timeout:10000}") int timeout) {
        OkHttpClient.Builder builder = this.elasticsearchOkHttpClientBuilder != null ? this.elasticsearchOkHttpClientBuilder : new OkHttpClient.Builder();
        for (Interceptor interceptor : this.networkInterceptors) {
            builder.addNetworkInterceptor(interceptor);
        }
        builder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)timeout, TimeUnit.MILLISECONDS);
        builder.writeTimeout((long)timeout, TimeUnit.MILLISECONDS);
        return builder.build();
    }
}

