/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.mysql;

import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import zipkin.autoconfigure.storage.mysql.ZipkinMySQLStorageProperties;
import zipkin.storage.StorageComponent;
import zipkin.storage.mysql.MySQLStorage;

@Configuration
@EnableConfigurationProperties(value={ZipkinMySQLStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinMySQLStorageAutoConfiguration {
    @Autowired(required=false)
    ZipkinMySQLStorageProperties mysql;
    @Autowired(required=false)
    @Qualifier(value="tracingExecuteListenerProvider")
    ExecuteListenerProvider listener;

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    Executor executor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("ZipkinMySQLStorage-");
        executor.initialize();
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    DataSource mysqlDataSource() {
        StringBuilder url = new StringBuilder("jdbc:mysql://");
        url.append(this.mysql.getHost()).append(":").append(this.mysql.getPort());
        url.append("/").append(this.mysql.getDb());
        url.append("?autoReconnect=true");
        url.append("&useSSL=").append(this.mysql.isUseSsl());
        url.append("&useUnicode=yes&characterEncoding=UTF-8");
        HikariDataSource result = new HikariDataSource();
        result.setDriverClassName("org.mariadb.jdbc.Driver");
        result.setJdbcUrl(url.toString());
        result.setMaximumPoolSize(this.mysql.getMaxActive());
        result.setUsername(this.mysql.getUsername());
        result.setPassword(this.mysql.getPassword());
        return result;
    }

    @Bean
    StorageComponent storage(Executor executor, DataSource dataSource, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId) {
        return MySQLStorage.builder().strictTraceId(strictTraceId).executor(executor).datasource(dataSource).listenerProvider(this.listener).build();
    }
}

