/*
 * Decompiled with CFR 0.152.
 */
package zipkin.junit;

import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import okio.GzipSource;
import okio.Source;
import zipkin.Codec;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.JsonCodec;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageComponent;

final class ZipkinDispatcher
extends Dispatcher {
    private final SpanStore store;
    private final Collector consumer;
    private final CollectorMetrics metrics;
    private final MockWebServer server;

    ZipkinDispatcher(StorageComponent storage, CollectorMetrics metrics, MockWebServer server) {
        this.store = storage.spanStore();
        this.consumer = Collector.builder(((Object)((Object)this)).getClass()).storage(storage).metrics(metrics).build();
        this.metrics = metrics;
        this.server = server;
    }

    public MockResponse dispatch(RecordedRequest request) {
        HttpUrl url = this.server.url(request.getPath());
        if (request.getMethod().equals("GET")) {
            if (url.encodedPath().equals("/health")) {
                return new MockResponse().setBody("OK\n");
            }
            if (url.encodedPath().equals("/api/v1/services")) {
                return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings(this.store.getServiceNames()));
            }
            if (url.encodedPath().equals("/api/v1/spans")) {
                String serviceName = url.queryParameter("serviceName");
                return ZipkinDispatcher.jsonResponse(Codec.JSON.writeStrings(this.store.getSpanNames(serviceName)));
            }
            if (url.encodedPath().equals("/api/v1/dependencies")) {
                Long endTs = ZipkinDispatcher.maybeLong(url.queryParameter("endTs"));
                Long lookback = ZipkinDispatcher.maybeLong(url.queryParameter("lookback"));
                List result = this.store.getDependencies(endTs.longValue(), lookback);
                return ZipkinDispatcher.jsonResponse(Codec.JSON.writeDependencyLinks(result));
            }
            if (url.encodedPath().equals("/api/v1/traces")) {
                QueryRequest queryRequest = ZipkinDispatcher.toQueryRequest(url);
                return ZipkinDispatcher.jsonResponse(Codec.JSON.writeTraces(this.store.getTraces(queryRequest)));
            }
            if (url.encodedPath().startsWith("/api/v1/trace/")) {
                List trace;
                String traceId = url.encodedPath().replace("/api/v1/trace/", "");
                long id = new Buffer().writeUtf8(traceId).readHexadecimalUnsignedLong();
                List list = trace = url.queryParameterNames().contains("raw") ? this.store.getRawTrace(id) : this.store.getTrace(id);
                if (trace != null) {
                    return ZipkinDispatcher.jsonResponse(Codec.JSON.writeSpans(trace));
                }
            }
        } else if (request.getMethod().equals("POST")) {
            if (url.encodedPath().equals("/api/v1/spans")) {
                String type;
                this.metrics.incrementMessages();
                byte[] body = request.getBody().readByteArray();
                String encoding = request.getHeader("Content-Encoding");
                if (encoding != null && encoding.contains("gzip")) {
                    try {
                        Buffer result = new Buffer();
                        GzipSource source = new GzipSource((Source)new Buffer().write(body));
                        while (source.read(result, Integer.MAX_VALUE) != -1L) {
                        }
                        body = result.readByteArray();
                    }
                    catch (IOException e) {
                        this.metrics.incrementMessagesDropped();
                        return new MockResponse().setResponseCode(400).setBody("Cannot gunzip spans");
                    }
                }
                JsonCodec codec = (type = request.getHeader("Content-Type")) != null && type.contains("/x-thrift") ? Codec.THRIFT : Codec.JSON;
                final MockResponse result = new MockResponse();
                this.consumer.acceptSpans(body, (Codec)codec, (Callback)new Callback<Void>(){

                    public void onSuccess(Void value) {
                        result.setResponseCode(202);
                    }

                    public void onError(Throwable t) {
                        String message = t.getMessage();
                        result.setBody(message).setResponseCode(message.startsWith("Cannot store") ? 500 : 400);
                    }
                });
                return result;
            }
        } else {
            return new MockResponse().setResponseCode(405);
        }
        return new MockResponse().setResponseCode(404);
    }

    static QueryRequest toQueryRequest(HttpUrl url) {
        return QueryRequest.builder().serviceName(url.queryParameter("serviceName")).spanName(url.queryParameter("spanName")).parseAnnotationQuery(url.queryParameter("annotationQuery")).minDuration(ZipkinDispatcher.maybeLong(url.queryParameter("minDuration"))).maxDuration(ZipkinDispatcher.maybeLong(url.queryParameter("maxDuration"))).endTs(ZipkinDispatcher.maybeLong(url.queryParameter("endTs"))).lookback(ZipkinDispatcher.maybeLong(url.queryParameter("lookback"))).limit(ZipkinDispatcher.maybeInteger(url.queryParameter("limit"))).build();
    }

    static Long maybeLong(String input) {
        return input != null ? Long.valueOf(input) : null;
    }

    static Integer maybeInteger(String input) {
        return input != null ? Integer.valueOf(input) : null;
    }

    static MockResponse jsonResponse(byte[] content) {
        return new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(new Buffer().write(content));
    }
}

