/*
 * Decompiled with CFR 0.152.
 */
package zipkin.junit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import okio.GzipSink;
import okio.Sink;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import zipkin.InMemoryCollectorMetrics;
import zipkin.Span;
import zipkin.collector.CollectorMetrics;
import zipkin.junit.HttpFailure;
import zipkin.junit.ZipkinDispatcher;
import zipkin.storage.InMemoryStorage;
import zipkin.storage.StorageComponent;

public final class ZipkinRule
implements TestRule {
    private final InMemoryStorage storage = new InMemoryStorage();
    private final InMemoryCollectorMetrics metrics = new InMemoryCollectorMetrics();
    private final MockWebServer server = new MockWebServer();
    private final BlockingQueue<MockResponse> failureQueue = new LinkedBlockingQueue<MockResponse>();
    private final AtomicInteger receivedSpanBytes = new AtomicInteger();

    public ZipkinRule() {
        Dispatcher dispatcher = new Dispatcher(){
            final ZipkinDispatcher successDispatch;
            {
                this.successDispatch = new ZipkinDispatcher((StorageComponent)ZipkinRule.this.storage, (CollectorMetrics)ZipkinRule.this.metrics, ZipkinRule.this.server);
            }

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse maybeFailure = (MockResponse)ZipkinRule.this.failureQueue.poll();
                if (maybeFailure != null) {
                    return maybeFailure;
                }
                MockResponse result = this.successDispatch.dispatch(request);
                if (request.getMethod().equals("POST")) {
                    ZipkinRule.this.receivedSpanBytes.addAndGet((int)request.getBodySize());
                }
                String encoding = request.getHeaders().get("Accept-Encoding");
                if (result.getBody() != null && encoding != null && encoding.contains("gzip")) {
                    try {
                        Buffer sink = new Buffer();
                        GzipSink gzipSink = new GzipSink((Sink)sink);
                        gzipSink.write(result.getBody(), result.getBody().size());
                        gzipSink.close();
                        result.setBody(sink);
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    result.setHeader("Content-Encoding", (Object)"gzip");
                }
                return result;
            }

            public MockResponse peek() {
                MockResponse maybeFailure = (MockResponse)ZipkinRule.this.failureQueue.peek();
                if (maybeFailure != null) {
                    return maybeFailure;
                }
                return new MockResponse().setSocketPolicy(SocketPolicy.KEEP_OPEN);
            }
        };
        this.server.setDispatcher(dispatcher);
    }

    public String httpUrl() {
        return String.format("http://%s:%s", this.server.getHostName(), this.server.getPort());
    }

    public int httpRequestCount() {
        return this.server.getRequestCount();
    }

    public InMemoryCollectorMetrics collectorMetrics() {
        return this.metrics;
    }

    public ZipkinRule storeSpans(List<Span> spans) {
        this.storage.spanConsumer().accept(spans);
        return this;
    }

    public ZipkinRule enqueueFailure(HttpFailure failure) {
        this.failureQueue.add(failure.response);
        return this;
    }

    public List<List<Span>> getTraces() {
        List traceIds = this.storage.spanStore().traceIds();
        ArrayList<List<Span>> result = new ArrayList<List<Span>>(traceIds.size());
        Iterator iterator = traceIds.iterator();
        while (iterator.hasNext()) {
            long traceId = (Long)iterator.next();
            result.add(this.storage.spanStore().getTrace(traceId));
        }
        return result;
    }

    public void start(int httpPort) throws IOException {
        this.server.start(httpPort);
    }

    public void shutdown() throws IOException {
        this.server.shutdown();
    }

    public Statement apply(Statement base, Description description) {
        return this.server.apply(base, description);
    }
}

