/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import zipkin.Annotation;
import zipkin.Codec;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.Callback;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.HttpBulkIndexer;
import zipkin.storage.elasticsearch.http.IndexNameFormatter;

class ElasticsearchHttpSpanConsumer
implements AsyncSpanConsumer {
    final ElasticsearchHttpStorage es;
    final IndexNameFormatter indexNameFormatter;
    private static final byte[] TIMESTAMP_MILLIS_PREFIX = "{\"timestamp_millis\":".getBytes(Util.UTF_8);

    ElasticsearchHttpSpanConsumer(ElasticsearchHttpStorage es) {
        this.es = es;
        this.indexNameFormatter = es.indexNameFormatter();
    }

    public void accept(List<Span> spans, Callback<Void> callback) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            HttpBulkIndexer indexer = new HttpBulkIndexer("index-span", this.es);
            Map<String, Set<Pair<String>>> indexToServiceSpans = this.indexSpans(indexer, spans);
            if (!indexToServiceSpans.isEmpty()) {
                this.indexNames(indexer, indexToServiceSpans);
            }
            indexer.execute(callback);
        }
        catch (Throwable t) {
            Util.propagateIfFatal((Throwable)t);
            callback.onError(t);
        }
    }

    Map<String, Set<Pair<String>>> indexSpans(HttpBulkIndexer indexer, List<Span> spans) {
        LinkedHashMap<String, Set<Pair<String>>> indexToServiceSpans = new LinkedHashMap<String, Set<Pair<String>>>();
        for (Span span : spans) {
            String index;
            Long timestampMillis;
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            if (timestamp != null) {
                timestampMillis = TimeUnit.MICROSECONDS.toMillis(timestamp);
                index = this.indexNameFormatter.indexNameForTimestamp(timestampMillis);
            } else {
                timestampMillis = null;
                Long indexTimestamp = null;
                int i = 0;
                int length = span.annotations.size();
                if (i < length) {
                    indexTimestamp = ((Annotation)span.annotations.get((int)i)).timestamp / 1000L;
                }
                if (indexTimestamp == null) {
                    indexTimestamp = System.currentTimeMillis();
                }
                index = this.indexNameFormatter.indexNameForTimestamp(indexTimestamp);
            }
            if (!span.name.isEmpty()) {
                this.putServiceSpans(indexToServiceSpans, index, span);
            }
            byte[] document = Codec.JSON.writeSpan(span);
            if (timestampMillis != null) {
                document = ElasticsearchHttpSpanConsumer.prefixWithTimestampMillis(document, timestampMillis);
            }
            indexer.add(index, "span", document, null);
        }
        return indexToServiceSpans;
    }

    void putServiceSpans(Map<String, Set<Pair<String>>> indexToServiceSpans, String index, Span s) {
        Set<Pair<String>> serviceSpans = indexToServiceSpans.get(index);
        if (serviceSpans == null) {
            serviceSpans = new LinkedHashSet<Pair<String>>();
            indexToServiceSpans.put(index, serviceSpans);
        }
        for (String serviceName : s.serviceNames()) {
            serviceSpans.add((Pair<String>)Pair.create((Object)serviceName, (Object)s.name));
        }
    }

    void indexNames(HttpBulkIndexer indexer, Map<String, Set<Pair<String>>> indexToServiceSpans) throws IOException {
        Buffer buffer = new Buffer();
        for (Map.Entry<String, Set<Pair<String>>> entry : indexToServiceSpans.entrySet()) {
            String index = entry.getKey();
            for (Pair<String> serviceSpan : entry.getValue()) {
                JsonWriter writer = JsonWriter.of((BufferedSink)buffer);
                writer.beginObject();
                writer.name("serviceName").value((String)serviceSpan._1);
                writer.name("spanName").value((String)serviceSpan._2);
                writer.endObject();
                byte[] document = buffer.readByteArray();
                indexer.add(index, "servicespan", document, (String)serviceSpan._1 + "|" + (String)serviceSpan._2);
            }
        }
    }

    static byte[] prefixWithTimestampMillis(byte[] input, long timestampMillis) {
        String dateAsString = Long.toString(timestampMillis);
        byte[] newSpanBytes = new byte[TIMESTAMP_MILLIS_PREFIX.length + dateAsString.length() + input.length];
        int pos = 0;
        System.arraycopy(TIMESTAMP_MILLIS_PREFIX, 0, newSpanBytes, pos, TIMESTAMP_MILLIS_PREFIX.length);
        pos += TIMESTAMP_MILLIS_PREFIX.length;
        int length = dateAsString.length();
        for (int i = 0; i < length; ++i) {
            newSpanBytes[pos++] = (byte)dateAsString.charAt(i);
        }
        newSpanBytes[pos++] = 44;
        System.arraycopy(input, 1, newSpanBytes, pos, input.length - 1);
        return newSpanBytes;
    }
}

