/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.util.Iterator;
import org.jooq.Record5;
import zipkin.internal.DependencyLinkSpan;
import zipkin.internal.PeekingIterator;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class DependencyLinkSpanIterator
implements Iterator<DependencyLinkSpan> {
    final PeekingIterator<Record5<Long, Long, Long, String, String>> delegate;
    final Long traceId;

    DependencyLinkSpanIterator(PeekingIterator<Record5<Long, Long, Long, String, String>> delegate, Long traceId) {
        this.delegate = delegate;
        this.traceId = traceId;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() && ((Long)((Record5)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID)).equals(this.traceId);
    }

    @Override
    public DependencyLinkSpan next() {
        Record5 row = (Record5)this.delegate.next();
        DependencyLinkSpan.Builder result = DependencyLinkSpan.builder((long)this.traceId, (Long)((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID)), (long)((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)));
        this.parseClientAndServerNames(result, (String)row.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), (String)row.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME));
        while (this.hasNext()) {
            Record5 next = (Record5)this.delegate.peek();
            if (next == null) continue;
            if (!((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)).equals(next.getValue(ZipkinSpans.ZIPKIN_SPANS.ID))) break;
            this.delegate.next();
            this.parseClientAndServerNames(result, (String)next.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), (String)next.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME));
        }
        return result.build();
    }

    void parseClientAndServerNames(DependencyLinkSpan.Builder span, String key, String value) {
        if (key == null) {
            return;
        }
        switch (key) {
            case "ca": {
                span.caService(value);
                break;
            }
            case "cs": {
                span.csService(value);
                break;
            }
            case "sa": {
                span.saService(value);
                break;
            }
            case "sr": {
                span.srService(value);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static final class ByTraceId
    implements Iterator<Iterator<DependencyLinkSpan>> {
        final PeekingIterator<Record5<Long, Long, Long, String, String>> delegate;
        Long currentTraceId;

        ByTraceId(Iterator<Record5<Long, Long, Long, String, String>> delegate) {
            this.delegate = new PeekingIterator(delegate);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Iterator<DependencyLinkSpan> next() {
            this.currentTraceId = (Long)((Record5)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
            return new DependencyLinkSpanIterator(this.delegate, this.currentTraceId);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

