/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import zipkin.internal.Lazy;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.internal.generated.tables.ZipkinDependencies;

final class HasPreAggregatedDependencies
extends Lazy<Boolean> {
    private static final Logger LOG = Logger.getLogger(HasPreAggregatedDependencies.class.getName());
    final DataSource datasource;
    final DSLContexts context;

    HasPreAggregatedDependencies(DataSource datasource, DSLContexts context) {
        this.datasource = datasource;
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean compute() {
        try (Connection conn = this.datasource.getConnection();){
            DSLContext dsl = this.context.get(conn);
            Boolean bl = (Integer)((Record1)dsl.select((SelectField)DSL.count()).from((TableLike)ZipkinDependencies.ZIPKIN_DEPENDENCIES).fetchAny()).value1() > 0;
            return bl;
        }
        catch (DataAccessException e) {
            if (e.sqlState().equals("42S02")) {
                LOG.warning("zipkin_dependencies doesn't exist, so pre-aggregated dependencies are not supported. Execute mysql.sql located in this jar to add the table");
                return false;
            }
            HasPreAggregatedDependencies.problemReading((Exception)((Object)e));
            return false;
        }
        catch (RuntimeException | SQLException e) {
            HasPreAggregatedDependencies.problemReading(e);
        }
        return false;
    }

    static void problemReading(Exception e) {
        LOG.log(Level.WARNING, "problem reading zipkin_dependencies", e);
    }
}

