/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOffsetStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinker;
import zipkin.internal.Lazy;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.DependencyLinkSpanIterator;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinDependencies;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class MySQLSpanStore
implements SpanStore {
    static final Field<?>[] ANNOTATION_FIELDS_WITHOUT_IPV6;
    private final DataSource datasource;
    private final DSLContexts context;
    private final Lazy<Boolean> hasIpv6;
    private final Lazy<Boolean> hasPreAggregatedDependencies;

    MySQLSpanStore(DataSource datasource, DSLContexts context, Lazy<Boolean> hasIpv6, Lazy<Boolean> hasPreAggregatedDependencies) {
        this.datasource = datasource;
        this.context = context;
        this.hasIpv6 = hasIpv6;
        this.hasPreAggregatedDependencies = hasPreAggregatedDependencies;
    }

    private Endpoint endpoint(Record a) {
        String serviceName = (String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
        if (serviceName == null) {
            return null;
        }
        return Endpoint.builder().serviceName(serviceName).port((Short)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT)).ipv4(((Integer)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4)).intValue()).ipv6((Boolean)this.hasIpv6.get() != false ? (byte[])a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6) : null).build();
    }

    private static SelectOffsetStep<Record1<Long>> toTraceIdQuery(DSLContext context, QueryRequest request) {
        ZipkinAnnotations aTable;
        long endTs = request.endTs > 0L && request.endTs != Long.MAX_VALUE ? request.endTs * 1000L : System.currentTimeMillis() * 1000L;
        Table<?> table = ZipkinSpans.ZIPKIN_SPANS.join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))});
        int i = 0;
        for (String string : request.annotations) {
            aTable = ZipkinAnnotations.ZIPKIN_ANNOTATIONS.as("a" + i++);
            table = MySQLSpanStore.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(aTable.TRACE_ID)}).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(aTable.SPAN_ID)).and(aTable.A_TYPE.eq((Object)-1)).and(aTable.A_KEY.eq((Object)string)), aTable, request.serviceName);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            aTable = ZipkinAnnotations.ZIPKIN_ANNOTATIONS.as("a" + i++);
            table = MySQLSpanStore.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(aTable.TRACE_ID)}).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(aTable.SPAN_ID)).and(aTable.A_TYPE.eq((Object)BinaryAnnotation.Type.STRING.value)).and(aTable.A_KEY.eq((Object)((String)entry.getKey()))).and(aTable.A_VALUE.eq((Object)((String)entry.getValue()).getBytes(Util.UTF_8))), aTable, request.serviceName);
        }
        SelectConditionStep dsl = context.selectDistinct(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).from((TableLike)table).where(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)(endTs - request.lookback * 1000L), (Object)endTs)});
        if (request.serviceName != null) {
            dsl.and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)request.serviceName));
        }
        if (request.spanName != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.NAME.eq((Object)request.spanName));
        }
        if (request.minDuration != null && request.maxDuration != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.between((Object)request.minDuration, (Object)request.maxDuration));
        } else if (request.minDuration != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.greaterOrEqual((Object)request.minDuration));
        }
        return dsl.orderBy(ZipkinSpans.ZIPKIN_SPANS.START_TS.desc()).limit(request.limit);
    }

    static Table<?> maybeOnService(TableOnConditionStep<Record> table, ZipkinAnnotations aTable, String serviceName) {
        if (serviceName == null) {
            return table;
        }
        return table.and(aTable.ENDPOINT_SERVICE_NAME.eq((Object)serviceName));
    }

    List<List<Span>> getTraces(@Nullable QueryRequest request, @Nullable Long traceId, boolean raw) {
        Map dbAnnotations;
        Map spansWithoutAnnotations;
        try {
            Connection conn = this.datasource.getConnection();
            Object object = null;
            try {
                Condition traceIdCondition;
                if (request != null) {
                    List traceIds = MySQLSpanStore.toTraceIdQuery(this.context.get(conn), request).fetch(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
                    traceIdCondition = ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.in((Collection)traceIds);
                } else {
                    traceIdCondition = ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq((Object)traceId);
                }
                spansWithoutAnnotations = this.context.get(conn).selectFrom((Table)ZipkinSpans.ZIPKIN_SPANS).where(new Condition[]{traceIdCondition}).stream().map(r -> Span.builder().traceId(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID)).longValue()).name((String)r.getValue(ZipkinSpans.ZIPKIN_SPANS.NAME)).id(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)).longValue()).parentId((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID)).timestamp((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.START_TS)).duration((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.DURATION)).debug((Boolean)r.getValue(ZipkinSpans.ZIPKIN_SPANS.DEBUG)).build()).collect(Collectors.groupingBy(s -> s.traceId, LinkedHashMap::new, Collectors.toList()));
                dbAnnotations = this.context.get(conn).select((Boolean)this.hasIpv6.get() != false ? ZipkinAnnotations.ZIPKIN_ANNOTATIONS.fields() : ANNOTATION_FIELDS_WITHOUT_IPV6).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(new Condition[]{ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID.in(spansWithoutAnnotations.keySet())}).orderBy(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP.asc(), ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.asc()).stream().collect(Collectors.groupingBy(a -> Pair.create((Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID)), (Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))), LinkedHashMap::new, Collectors.toList()));
            }
            catch (Throwable traceIdCondition) {
                object = traceIdCondition;
                throw traceIdCondition;
            }
            finally {
                if (conn != null) {
                    if (object != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable traceIdCondition) {
                            ((Throwable)object).addSuppressed(traceIdCondition);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + request + ": " + e.getMessage());
        }
        ArrayList<List<Span>> result = new ArrayList<List<Span>>(spansWithoutAnnotations.keySet().size());
        for (List spans : spansWithoutAnnotations.values()) {
            List<Span> trace = new ArrayList(spans.size());
            for (Span s2 : spans) {
                Span.Builder span = s2.toBuilder();
                Pair key = Pair.create((Object)s2.traceId, (Object)s2.id);
                if (dbAnnotations.containsKey(key)) {
                    for (Record a2 : (List)dbAnnotations.get(key)) {
                        Endpoint endpoint = this.endpoint(a2);
                        int type = (Integer)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE);
                        if (type == -1) {
                            span.addAnnotation(Annotation.create((long)((Long)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP)), (String)((String)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY)), (Endpoint)endpoint));
                            continue;
                        }
                        span.addBinaryAnnotation(BinaryAnnotation.create((String)((String)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY)), (byte[])((byte[])a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE)), (BinaryAnnotation.Type)BinaryAnnotation.Type.fromValue((int)type), (Endpoint)endpoint));
                    }
                }
                Span rawSpan = span.build();
                trace.add(raw ? rawSpan : ApplyTimestampAndDuration.apply((Span)rawSpan));
            }
            if (!raw) {
                trace = CorrectForClockSkew.apply(trace);
            }
            result.add(trace);
        }
        if (!raw) {
            Collections.sort(result, (left, right) -> ((Span)right.get(0)).compareTo((Span)left.get(0)));
        }
        return result;
    }

    public List<List<Span>> getTraces(QueryRequest request) {
        return this.getTraces(request, null, false);
    }

    public List<Span> getTrace(long traceId) {
        List<List<Span>> result = this.getTraces(null, traceId, false);
        return result.isEmpty() ? null : result.get(0);
    }

    public List<Span> getRawTrace(long traceId) {
        List<List<Span>> result = this.getTraces(null, traceId, true);
        return result.isEmpty() ? null : result.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getServiceNames() {
        try (Connection conn = this.datasource.getConnection();){
            List list = this.context.get(conn).selectDistinct(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(new Condition[]{ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.isNotNull().and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.ne((Object)""))}).fetch(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + e + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSpanNames(String serviceName) {
        if (serviceName == null) {
            return Collections.emptyList();
        }
        serviceName = serviceName.toLowerCase();
        try (Connection conn = this.datasource.getConnection();){
            List list = this.context.get(conn).selectDistinct(ZipkinSpans.ZIPKIN_SPANS.NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID)}).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID)).where(new Condition[]{ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)serviceName)}).orderBy(ZipkinSpans.ZIPKIN_SPANS.NAME).fetch(ZipkinSpans.ZIPKIN_SPANS.NAME);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + serviceName + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        try (Connection conn = this.datasource.getConnection();){
            if (((Boolean)this.hasPreAggregatedDependencies.get()).booleanValue()) {
                List days = Util.getDays((long)endTs, (Long)lookback);
                List unmerged = this.context.get(conn).selectFrom((Table)ZipkinDependencies.ZIPKIN_DEPENDENCIES).where(new Condition[]{ZipkinDependencies.ZIPKIN_DEPENDENCIES.DAY.in((Collection)days)}).fetch(l -> DependencyLink.create((String)((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.PARENT)), (String)((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CHILD)), (long)((Long)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CALL_COUNT))));
                List list = DependencyLinker.merge((Iterable)unmerged);
                return list;
            }
            List<DependencyLink> list = this.aggregateDependencies(endTs, lookback, conn);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying dependencies for endTs " + endTs + " and lookback " + lookback + ": " + e.getMessage());
        }
    }

    List<DependencyLink> aggregateDependencies(long endTs, @Nullable Long lookback, Connection conn) {
        Cursor cursor = this.context.get(conn).selectDistinct(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, ZipkinSpans.ZIPKIN_SPANS.ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS.leftJoin((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))}).and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.in((Object[])new String[]{"cs", "ca", "sr", "sa"}))).where(new Condition[]{lookback == null ? ZipkinSpans.ZIPKIN_SPANS.START_TS.lessOrEqual((Object)endTs) : ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)((endTs *= 1000L) - lookback * 1000L), (Object)endTs)}).groupBy(new GroupField[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY}).fetchLazy();
        DependencyLinkSpanIterator.ByTraceId traces = new DependencyLinkSpanIterator.ByTraceId(cursor.iterator());
        if (!traces.hasNext()) {
            return Collections.emptyList();
        }
        DependencyLinker linker = new DependencyLinker();
        while (traces.hasNext()) {
            linker.putTrace((Iterator)traces.next());
        }
        return linker.link();
    }

    static {
        ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.fields()));
        list.remove(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6);
        list.trimToSize();
        ANNOTATION_FIELDS_WITHOUT_IPV6 = list.toArray(new Field[list.size()]);
    }
}

