/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.util.Iterator;
import org.jooq.Record;
import org.jooq.TableField;
import zipkin.BinaryAnnotation;
import zipkin.internal.Nullable;
import zipkin.internal.PeekingIterator;
import zipkin.internal.Util;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;
import zipkin2.Endpoint;
import zipkin2.Span;

final class DependencyLinkV2SpanIterator
implements Iterator<Span> {
    final PeekingIterator<Record> delegate;
    @Nullable
    final Long traceIdHi;
    final long traceIdLo;

    DependencyLinkV2SpanIterator(PeekingIterator<Record> delegate, @Nullable Long traceIdHi, long traceIdLo) {
        this.delegate = delegate;
        this.traceIdHi = traceIdHi;
        this.traceIdLo = traceIdLo;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() && (Long)((Record)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID) == this.traceIdLo;
    }

    @Override
    public Span next() {
        Record row = (Record)this.delegate.peek();
        long spanId = (Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID);
        boolean error = false;
        String srService = null;
        String csService = null;
        String caService = null;
        String saService = null;
        while (this.hasNext() && spanId == (Long)((Record)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.ID)) {
            Record next = (Record)this.delegate.next();
            String key = DependencyLinkV2SpanIterator.emptyToNull(next, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY);
            String value = DependencyLinkV2SpanIterator.emptyToNull(next, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
            if (key == null || value == null) continue;
            switch (key) {
                case "ca": {
                    caService = value;
                    break;
                }
                case "cs": {
                    csService = value;
                    break;
                }
                case "sa": {
                    saService = value;
                    break;
                }
                case "sr": {
                    srService = value;
                    break;
                }
                case "error": {
                    error = BinaryAnnotation.Type.STRING.value == (Integer)next.get(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE);
                }
            }
        }
        if (caService == null) {
            caService = csService;
        }
        if (Util.equal(saService, caService)) {
            caService = null;
        }
        Long parentId = (Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID);
        Span.Builder result = Span.newBuilder().traceId(Util.toLowerHex((long)(this.traceIdHi != null ? this.traceIdHi : 0L), (long)this.traceIdLo)).parentId(parentId != null ? Util.toLowerHex((long)parentId) : null).id(Util.toLowerHex((long)spanId));
        if (error) {
            result.putTag("error", "");
        }
        if (srService != null) {
            return result.kind(Span.Kind.SERVER).localEndpoint(DependencyLinkV2SpanIterator.ep(srService)).remoteEndpoint(DependencyLinkV2SpanIterator.ep(caService)).build();
        }
        if (saService != null) {
            return result.kind((Span.Kind)(csService != null ? Span.Kind.CLIENT : null)).localEndpoint(DependencyLinkV2SpanIterator.ep(caService)).remoteEndpoint(DependencyLinkV2SpanIterator.ep(saService)).build();
        }
        if (csService != null) {
            return result.kind(Span.Kind.SERVER).localEndpoint(DependencyLinkV2SpanIterator.ep(caService)).build();
        }
        return result.build();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static long traceIdHigh(PeekingIterator<Record> delegate) {
        return (Long)((Record)delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
    }

    @Nullable
    static String emptyToNull(Record next, TableField<Record, String> field) {
        String result = (String)next.getValue(field);
        return result != null && !"".equals(result) ? result : null;
    }

    static Endpoint ep(@Nullable String serviceName) {
        return serviceName != null ? Endpoint.newBuilder().serviceName(serviceName).build() : null;
    }

    static final class ByTraceId
    implements Iterator<Iterator<Span>> {
        final PeekingIterator<Record> delegate;
        final boolean hasTraceIdHigh;
        @Nullable
        Long currentTraceIdHi;
        long currentTraceIdLo;

        ByTraceId(Iterator<Record> delegate, boolean hasTraceIdHigh) {
            this.delegate = new PeekingIterator(delegate);
            this.hasTraceIdHigh = hasTraceIdHigh;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Iterator<Span> next() {
            this.currentTraceIdHi = this.hasTraceIdHigh ? Long.valueOf(DependencyLinkV2SpanIterator.traceIdHigh(this.delegate)) : null;
            this.currentTraceIdLo = (Long)((Record)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
            return new DependencyLinkV2SpanIterator(this.delegate, this.currentTraceIdHi, this.currentTraceIdLo);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

