/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import zipkin.Component;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Util;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Sender;
import zipkin.reporter.okhttp3.AutoValue_OkHttpSender;
import zipkin.reporter.okhttp3.RequestBodyMessageEncoder;

public abstract class OkHttpSender
extends LazyCloseable<OkHttpClient>
implements Sender {
    volatile boolean closeCalled;

    public static OkHttpSender create(String endpoint) {
        return OkHttpSender.builder().endpoint(endpoint).build();
    }

    public static Builder builder() {
        return new AutoValue_OkHttpSender.Builder().encoding(Encoding.THRIFT).compressionEnabled(true).maxRequests(64).messageMaxBytes(0x500000);
    }

    public abstract Builder toBuilder();

    abstract HttpUrl endpoint();

    abstract int maxRequests();

    abstract boolean compressionEnabled();

    abstract RequestBodyMessageEncoder encoder();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public void sendSpans(List<byte[]> encodedSpans, Callback callback) {
        block3: {
            if (this.closeCalled) {
                throw new IllegalStateException("closed");
            }
            try {
                Request request = this.newRequest(this.encoder().encode(encodedSpans));
                ((OkHttpClient)this.get()).newCall(request).enqueue((okhttp3.Callback)new CallbackAdapter(callback));
            }
            catch (Throwable e) {
                callback.onError(e);
                if (!(e instanceof Error)) break block3;
                throw (Error)e;
            }
        }
    }

    public Component.CheckResult check() {
        try {
            Request request = new Request.Builder().url(this.endpoint()).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"[]")).build();
            try (Response response = ((OkHttpClient)this.get()).newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("check response failed: " + response);
                }
            }
            return Component.CheckResult.OK;
        }
        catch (Exception e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    protected OkHttpClient compute() {
        ThreadPoolExecutor dispatchExecutor = new ThreadPoolExecutor(0, this.maxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), okhttp3.internal.Util.threadFactory((String)"OkHttpSender Dispatcher", (boolean)false));
        Dispatcher dispatcher = new Dispatcher((ExecutorService)dispatchExecutor);
        dispatcher.setMaxRequests(this.maxRequests());
        dispatcher.setMaxRequestsPerHost(this.maxRequests());
        return new OkHttpClient.Builder().dispatcher(dispatcher).build();
    }

    public void close() {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        OkHttpClient maybeNull = (OkHttpClient)this.maybeNull();
        if (maybeNull == null) {
            return;
        }
        Dispatcher dispatcher = maybeNull.dispatcher();
        dispatcher.executorService().shutdown();
        try {
            if (!dispatcher.executorService().awaitTermination(1L, TimeUnit.SECONDS)) {
                dispatcher.cancelAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    Request newRequest(RequestBody body) throws IOException {
        Request.Builder request = new Request.Builder().url(this.endpoint());
        if (this.compressionEnabled()) {
            request.addHeader("Content-Encoding", "gzip");
            Buffer gzipped = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)gzipped));
            body.writeTo(gzipSink);
            gzipSink.close();
            body = new BufferRequestBody(body.contentType(), gzipped);
        }
        request.post(body);
        return request.build();
    }

    public final String toString() {
        return "OkHttpSender(" + this.endpoint() + ")";
    }

    OkHttpSender() {
    }

    static final class CallbackAdapter
    implements okhttp3.Callback {
        final Callback delegate;

        CallbackAdapter(Callback delegate) {
            this.delegate = delegate;
        }

        public void onFailure(Call call, IOException e) {
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(Call call, Response response) throws IOException {
            try (ResponseBody responseBody = response.body();){
                if (response.isSuccessful()) {
                    this.delegate.onComplete();
                } else {
                    this.delegate.onError((Throwable)new IllegalStateException("response failed: " + response));
                }
            }
        }

        public String toString() {
            return "CallbackAdapter(" + this.delegate + ")";
        }
    }

    static final class BufferRequestBody
    extends RequestBody {
        final MediaType contentType;
        final Buffer body;

        BufferRequestBody(MediaType contentType, Buffer body) {
            this.contentType = contentType;
            this.body = body;
        }

        public long contentLength() throws IOException {
            return this.body.size();
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.body, this.body.size());
        }
    }

    public static abstract class Builder {
        public final Builder endpoint(String endpoint) {
            Util.checkNotNull((Object)endpoint, (String)"endpoint ex: http://zipkinhost:9411/api/v1/spans");
            HttpUrl parsed = HttpUrl.parse((String)endpoint);
            Util.checkArgument((parsed != null ? 1 : 0) != 0, (String)("invalid post url: " + endpoint), (Object[])new Object[0]);
            return this.endpoint(parsed);
        }

        public abstract Builder endpoint(HttpUrl var1);

        public abstract Builder compressionEnabled(boolean var1);

        public abstract Builder messageMaxBytes(int var1);

        public abstract Builder maxRequests(int var1);

        public abstract Builder encoding(Encoding var1);

        abstract int maxRequests();

        abstract Encoding encoding();

        public final OkHttpSender build() {
            if (this.encoding() == Encoding.JSON) {
                return this.encoder(RequestBodyMessageEncoder.JSON).autoBuild();
            }
            if (this.encoding() == Encoding.THRIFT) {
                return this.encoder(RequestBodyMessageEncoder.THRIFT).autoBuild();
            }
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding().name());
        }

        abstract Builder encoder(RequestBodyMessageEncoder var1);

        abstract OkHttpSender autoBuild();

        Builder() {
        }
    }
}

