/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave;

import brave.Span;
import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public final class ZipkinSpanHandler
extends SpanHandler {
    static final Logger logger = Logger.getLogger(ZipkinSpanHandler.class.getName());
    static final Map<Span.Kind, Span.Kind> BRAVE_TO_ZIPKIN_KIND = ZipkinSpanHandler.generateKindMap();
    final Reporter<Span> spanReporter;
    final Tag<Throwable> errorTag;
    final boolean alwaysReportSpans;

    public static SpanHandler create(Reporter<Span> spanReporter) {
        return ZipkinSpanHandler.newBuilder(spanReporter).build();
    }

    public static Builder newBuilder(Reporter<Span> spanReporter) {
        return new Builder(spanReporter);
    }

    ZipkinSpanHandler(Builder builder) {
        this.spanReporter = builder.spanReporter;
        this.errorTag = builder.errorTag;
        this.alwaysReportSpans = builder.alwaysReportSpans;
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (cause == SpanHandler.Cause.ABANDONED) {
            return true;
        }
        if (!this.alwaysReportSpans && !Boolean.TRUE.equals(context.sampled())) {
            return true;
        }
        this.maybeAddErrorTag(context, span);
        Span converted = ZipkinSpanHandler.convert(context, span);
        this.spanReporter.report((Object)converted);
        return true;
    }

    static Span convert(TraceContext context, MutableSpan span) {
        Span.Kind kind;
        Span.Builder result = Span.newBuilder().traceId(context.traceIdString()).parentId(context.parentIdString()).id(context.spanId()).name(span.name());
        long start = span.startTimestamp();
        long finish = span.finishTimestamp();
        result.timestamp(start);
        if (start != 0L && finish != 0L) {
            result.duration(Math.max(finish - start, 1L));
        }
        if ((kind = span.kind()) != null) {
            result.kind(BRAVE_TO_ZIPKIN_KIND.get(kind));
        }
        String localServiceName = span.localServiceName();
        String localIp = span.localIp();
        if (localServiceName != null || localIp != null) {
            result.localEndpoint(Endpoint.newBuilder().serviceName(localServiceName).ip(localIp).port(span.localPort()).build());
        }
        String remoteServiceName = span.remoteServiceName();
        String remoteIp = span.remoteIp();
        if (remoteServiceName != null || remoteIp != null) {
            result.remoteEndpoint(Endpoint.newBuilder().serviceName(remoteServiceName).ip(remoteIp).port(span.remotePort()).build());
        }
        span.forEachTag((MutableSpan.TagConsumer)Consumer.INSTANCE, (Object)result);
        span.forEachAnnotation((MutableSpan.AnnotationConsumer)Consumer.INSTANCE, (Object)result);
        if (span.shared()) {
            result.shared(true);
        }
        if (context.debug()) {
            result.debug(true);
        }
        return result.build();
    }

    void maybeAddErrorTag(TraceContext context, MutableSpan span) {
        if (span.error() == null) {
            return;
        }
        if (span.tag("error") == null) {
            this.errorTag.tag((Object)span.error(), context, span);
        }
    }

    public String toString() {
        return this.spanReporter.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinSpanHandler)) {
            return false;
        }
        return this.spanReporter.equals(((ZipkinSpanHandler)((Object)o)).spanReporter);
    }

    public final int hashCode() {
        return this.spanReporter.hashCode();
    }

    static Map<Span.Kind, Span.Kind> generateKindMap() {
        LinkedHashMap<Span.Kind, Span.Kind> result = new LinkedHashMap<Span.Kind, Span.Kind>();
        for (Span.Kind kind : Span.Kind.values()) {
            try {
                result.put(kind, Span.Kind.valueOf((String)kind.name()));
            }
            catch (RuntimeException e) {
                logger.warning("Could not map Brave kind " + kind + " to Zipkin");
            }
        }
        return result;
    }

    static enum Consumer implements MutableSpan.TagConsumer<Span.Builder>,
    MutableSpan.AnnotationConsumer<Span.Builder>
    {
        INSTANCE;


        public void accept(Span.Builder target, String key, String value) {
            target.putTag(key, value);
        }

        public void accept(Span.Builder target, long timestamp, String value) {
            target.addAnnotation(timestamp, value);
        }
    }

    public static final class Builder {
        Reporter<Span> spanReporter;
        Tag<Throwable> errorTag = Tags.ERROR;
        boolean alwaysReportSpans;

        Builder(Reporter<Span> spanReporter) {
            if (spanReporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            this.spanReporter = spanReporter;
        }

        public Builder errorTag(Tag<Throwable> errorTag) {
            this.errorTag = errorTag;
            return this;
        }

        public Builder alwaysReportSpans(boolean alwaysReportSpans) {
            this.alwaysReportSpans = alwaysReportSpans;
            return this;
        }

        public SpanHandler build() {
            if (this.spanReporter == Reporter.NOOP) {
                return SpanHandler.NOOP;
            }
            return new ZipkinSpanHandler(this);
        }
    }
}

