/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import zipkin2.Span;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.brave.ConvertingSpanReporter;

public class ZipkinSpanHandler
extends SpanHandler {
    final Reporter<MutableSpan> spanReporter;
    final boolean alwaysReportSpans;

    public static SpanHandler create(Reporter<Span> spanReporter) {
        return ZipkinSpanHandler.newBuilder(spanReporter).build();
    }

    public static Builder newBuilder(Reporter<Span> spanReporter) {
        if (spanReporter == null) {
            throw new NullPointerException("spanReporter == null");
        }
        return new ConvertingSpanReporterBuilder(spanReporter);
    }

    ZipkinSpanHandler(Reporter<MutableSpan> spanReporter, boolean alwaysReportSpans) {
        this.spanReporter = spanReporter;
        this.alwaysReportSpans = alwaysReportSpans;
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (!this.alwaysReportSpans && !Boolean.TRUE.equals(context.sampled())) {
            return true;
        }
        this.spanReporter.report((Object)span);
        return true;
    }

    public String toString() {
        return this.spanReporter.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinSpanHandler)) {
            return false;
        }
        return this.spanReporter.equals(((ZipkinSpanHandler)((Object)o)).spanReporter);
    }

    public final int hashCode() {
        return this.spanReporter.hashCode();
    }

    public static abstract class Builder {
        Tag<Throwable> errorTag = Tags.ERROR;
        boolean alwaysReportSpans;

        Builder() {
        }

        public Builder errorTag(Tag<Throwable> errorTag) {
            if (errorTag == null) {
                throw new NullPointerException("errorTag == null");
            }
            this.errorTag = errorTag;
            return this;
        }

        public Builder alwaysReportSpans(boolean alwaysReportSpans) {
            this.alwaysReportSpans = alwaysReportSpans;
            return this;
        }

        public abstract SpanHandler build();
    }

    static final class ConvertingSpanReporterBuilder
    extends Builder {
        final Reporter<Span> spanReporter;

        ConvertingSpanReporterBuilder(Reporter<Span> spanReporter) {
            this.spanReporter = spanReporter;
        }

        @Override
        public SpanHandler build() {
            if (this.spanReporter == Reporter.NOOP) {
                return SpanHandler.NOOP;
            }
            return new ZipkinSpanHandler(new ConvertingSpanReporter(this.spanReporter, (Tag<Throwable>)this.errorTag), this.alwaysReportSpans);
        }
    }
}

