/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave.internal;

import zipkin2.reporter.brave.internal.IpWriter;
import zipkin2.reporter.brave.internal.WriteBuffer;
import zipkin2.reporter.internal.Nullable;

final class Proto3Fields {
    static final int WIRETYPE_VARINT = 0;
    static final int WIRETYPE_FIXED64 = 1;
    static final int WIRETYPE_LENGTH_DELIMITED = 2;

    Proto3Fields() {
    }

    static int sizeOfLengthDelimitedField(int sizeInBytes) {
        return 1 + WriteBuffer.varintSizeInBytes(sizeInBytes) + sizeInBytes;
    }

    static final class BooleanField
    extends Field {
        BooleanField(int key) {
            super(key);
            assert (this.wireType == 0);
        }

        int sizeInBytes(boolean bool) {
            return bool ? 2 : 0;
        }

        void write(WriteBuffer b, boolean bool) {
            if (!bool) {
                return;
            }
            b.writeByte(this.key);
            b.writeByte(1);
        }
    }

    static class VarintField
    extends Field {
        VarintField(int key) {
            super(key);
            assert (this.wireType == 0);
        }

        int sizeInBytes(int number) {
            return number != 0 ? 1 + WriteBuffer.varintSizeInBytes(number) : 0;
        }

        void write(WriteBuffer b, int number) {
            if (number == 0) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(number);
        }

        int sizeInBytes(long number) {
            return number != 0L ? 1 + WriteBuffer.varintSizeInBytes(number) : 0;
        }

        void write(WriteBuffer b, long number) {
            if (number == 0L) {
                return;
            }
            b.writeByte(this.key);
            b.writeVarint(number);
        }
    }

    static final class Fixed64Field
    extends Field {
        Fixed64Field(int key) {
            super(key);
            assert (this.wireType == 1);
        }

        void write(WriteBuffer b, long number) {
            if (number == 0L) {
                return;
            }
            b.writeByte(this.key);
            b.writeLongLe(number);
        }

        int sizeInBytes(long number) {
            if (number == 0L) {
                return 0;
            }
            return 9;
        }
    }

    static class Utf8Field
    extends LengthDelimitedField<String> {
        Utf8Field(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(String utf8) {
            return utf8 != null ? WriteBuffer.utf8SizeInBytes(utf8) : 0;
        }

        @Override
        void writeValue(WriteBuffer b, String utf8) {
            b.writeUtf8(utf8);
        }
    }

    static class HexField
    extends LengthDelimitedField<String> {
        HexField(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(String hex) {
            if (hex == null) {
                return 0;
            }
            return hex.length() / 2;
        }

        @Override
        void writeValue(WriteBuffer b, String hex) {
            int length = hex.length();
            for (int i = 0; i < length; ++i) {
                int d1 = HexField.decodeLowerHex(hex.charAt(i++)) << 4;
                int d2 = HexField.decodeLowerHex(hex.charAt(i));
                b.writeByte((byte)(d1 + d2));
            }
        }

        static int decodeLowerHex(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            throw new AssertionError((Object)("not lowerHex " + c));
        }
    }

    static class IPv6Field
    extends LengthDelimitedField<String> {
        IPv6Field(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(String ipv6) {
            return ipv6 != null ? 16 : 0;
        }

        @Override
        void writeValue(WriteBuffer b, String ipv6) {
            IpWriter.writeIpv6Bytes(b, ipv6);
        }
    }

    static class IPv4Field
    extends LengthDelimitedField<String> {
        IPv4Field(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(@Nullable String ipv4) {
            return ipv4 != null ? 4 : 0;
        }

        @Override
        void writeValue(WriteBuffer b, String ipv4) {
            IpWriter.writeIpv4Bytes(b, ipv4);
        }
    }

    static class BytesField
    extends LengthDelimitedField<byte[]> {
        BytesField(int key) {
            super(key);
        }

        @Override
        int sizeOfValue(byte[] bytes) {
            return bytes.length;
        }

        @Override
        void writeValue(WriteBuffer b, byte[] bytes) {
            b.write(bytes);
        }
    }

    static abstract class LengthDelimitedField<T>
    extends Field {
        LengthDelimitedField(int key) {
            super(key);
            assert (this.wireType == 2);
        }

        final int sizeInBytes(T value) {
            if (value == null) {
                return 0;
            }
            int sizeOfValue = this.sizeOfValue(value);
            return Proto3Fields.sizeOfLengthDelimitedField(sizeOfValue);
        }

        final void write(WriteBuffer b, T value) {
            if (value == null) {
                return;
            }
            int sizeOfValue = this.sizeOfValue(value);
            b.writeByte(this.key);
            b.writeVarint(sizeOfValue);
            this.writeValue(b, value);
        }

        abstract int sizeOfValue(T var1);

        abstract void writeValue(WriteBuffer var1, T var2);
    }

    static class Field {
        final int fieldNumber;
        final int wireType;
        final int key;

        Field(int key) {
            this(key >>> 3, key & 7, key);
        }

        Field(int fieldNumber, int wireType, int key) {
            this.fieldNumber = fieldNumber;
            this.wireType = wireType;
            this.key = key;
        }

        static int fieldNumber(int key, int byteL) {
            int fieldNumber = key >>> 3;
            if (fieldNumber != 0) {
                return fieldNumber;
            }
            throw new IllegalArgumentException("Malformed: fieldNumber was zero at byte " + byteL);
        }

        static int wireType(int key, int byteL) {
            int wireType = key & 7;
            if (wireType != 0 && wireType != 1 && wireType != 2 && wireType != 5) {
                throw new IllegalArgumentException("Malformed: invalid wireType " + wireType + " at byte " + byteL);
            }
            return wireType;
        }
    }
}

