/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.beans;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

public class AsyncReporterFactoryBean
extends AbstractFactoryBean {
    Sender sender;
    SpanBytesEncoder encoder;
    ReporterMetrics metrics;
    Integer messageMaxBytes;
    Integer messageTimeout;
    Integer closeTimeout;
    Integer queuedMaxSpans;
    Integer queuedMaxBytes;

    public Class<? extends AsyncReporter> getObjectType() {
        return AsyncReporter.class;
    }

    protected AsyncReporter createInstance() {
        AsyncReporter.Builder builder = AsyncReporter.builder((Sender)this.sender);
        if (this.metrics != null) {
            builder.metrics(this.metrics);
        }
        if (this.messageMaxBytes != null) {
            builder.messageMaxBytes(this.messageMaxBytes.intValue());
        }
        if (this.messageTimeout != null) {
            builder.messageTimeout((long)this.messageTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (this.closeTimeout != null) {
            builder.closeTimeout((long)this.closeTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (this.queuedMaxSpans != null) {
            builder.queuedMaxSpans(this.queuedMaxSpans.intValue());
        }
        if (this.queuedMaxBytes != null) {
            builder.queuedMaxBytes(this.queuedMaxBytes.intValue());
        }
        return this.encoder != null ? builder.build((BytesEncoder)this.encoder) : builder.build();
    }

    protected void destroyInstance(Object instance) {
        ((AsyncReporter)instance).close();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public void setEncoder(SpanBytesEncoder encoder) {
        this.encoder = encoder;
    }

    public void setMetrics(ReporterMetrics metrics) {
        this.metrics = metrics;
    }

    public void setMessageMaxBytes(Integer messageMaxBytes) {
        this.messageMaxBytes = messageMaxBytes;
    }

    public void setMessageTimeout(Integer messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public void setCloseTimeout(Integer closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setQueuedMaxSpans(Integer queuedMaxSpans) {
        this.queuedMaxSpans = queuedMaxSpans;
    }

    public void setQueuedMaxBytes(Integer queuedMaxBytes) {
        this.queuedMaxBytes = queuedMaxBytes;
    }
}

