/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.Closeable;
import java.io.Flushable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Component;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.internal.AsyncReporter;

public class AsyncReporter<S>
extends Component
implements Reporter<S>,
Closeable,
Flushable {
    final zipkin2.reporter.internal.AsyncReporter<S> delegate;

    public static AsyncReporter<Span> create(BytesMessageSender sender) {
        return new Builder(sender).build();
    }

    public static Builder builder(BytesMessageSender sender) {
        return new Builder(sender);
    }

    AsyncReporter(zipkin2.reporter.internal.AsyncReporter<S> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void report(S span) {
        this.delegate.report(span);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public String toString() {
        return this.delegate.toString();
    }

    static final class BytesEncoderAdapter<S>
    implements BytesEncoder<S> {
        final BytesEncoder<S> delegate;

        BytesEncoderAdapter(BytesEncoder<S> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Encoding encoding() {
            return this.delegate.encoding();
        }

        @Override
        public int sizeInBytes(S input) {
            return this.delegate.sizeInBytes(input);
        }

        @Override
        public byte[] encode(S input) {
            return this.delegate.encode(input);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static final class Builder {
        final AsyncReporter.Builder delegate;
        final Encoding encoding;

        Builder(BytesMessageSender sender) {
            this.delegate = zipkin2.reporter.internal.AsyncReporter.newBuilder(sender);
            this.encoding = sender.encoding();
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.delegate.threadFactory(threadFactory);
            return this;
        }

        public Builder metrics(ReporterMetrics metrics) {
            this.delegate.metrics(metrics);
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.delegate.messageMaxBytes(messageMaxBytes);
            return this;
        }

        public Builder messageTimeout(long timeout, TimeUnit unit) {
            this.delegate.messageTimeout(timeout, unit);
            return this;
        }

        public Builder closeTimeout(long timeout, TimeUnit unit) {
            this.delegate.closeTimeout(timeout, unit);
            return this;
        }

        public Builder queuedMaxSpans(int queuedMaxSpans) {
            this.delegate.queuedMaxSpans(queuedMaxSpans);
            return this;
        }

        public Builder queuedMaxBytes(int queuedMaxBytes) {
            this.delegate.queuedMaxBytes(queuedMaxBytes);
            return this;
        }

        public AsyncReporter<Span> build() {
            switch (this.encoding) {
                case JSON: {
                    return this.build(SpanBytesEncoder.JSON_V2);
                }
                case PROTO3: {
                    return this.build(SpanBytesEncoder.PROTO3);
                }
                case THRIFT: {
                    return this.build(SpanBytesEncoder.THRIFT);
                }
            }
            throw new UnsupportedOperationException(this.encoding.name());
        }

        public <S> AsyncReporter<S> build(BytesEncoder<S> encoder) {
            if (encoder == null) {
                throw new NullPointerException("encoder == null");
            }
            return new AsyncReporter<S>(this.delegate.build(new BytesEncoderAdapter<S>(encoder)));
        }
    }
}

