/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Encoding;

public enum SpanBytesEncoder implements BytesEncoder<Span>
{
    THRIFT{

        @Override
        public Encoding encoding() {
            return Encoding.THRIFT;
        }

        @Override
        public int sizeInBytes(Span input) {
            return zipkin2.codec.SpanBytesEncoder.THRIFT.sizeInBytes((Object)input);
        }

        @Override
        public byte[] encode(Span input) {
            return zipkin2.codec.SpanBytesEncoder.THRIFT.encode((Object)input);
        }
    }
    ,
    JSON_V1{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return zipkin2.codec.SpanBytesEncoder.JSON_V1.sizeInBytes((Object)input);
        }

        @Override
        public byte[] encode(Span input) {
            return zipkin2.codec.SpanBytesEncoder.JSON_V1.encode((Object)input);
        }
    }
    ,
    JSON_V2{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(Span input) {
            return zipkin2.codec.SpanBytesEncoder.JSON_V2.sizeInBytes((Object)input);
        }

        @Override
        public byte[] encode(Span input) {
            return zipkin2.codec.SpanBytesEncoder.JSON_V2.encode((Object)input);
        }
    }
    ,
    PROTO3{

        @Override
        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        @Override
        public int sizeInBytes(Span input) {
            return zipkin2.codec.SpanBytesEncoder.PROTO3.sizeInBytes((Object)input);
        }

        @Override
        public byte[] encode(Span input) {
            return zipkin2.codec.SpanBytesEncoder.PROTO3.encode((Object)input);
        }
    };


    public static BytesEncoder<Span> forEncoding(Encoding encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding == null");
        }
        switch (encoding) {
            case JSON: {
                return JSON_V2;
            }
            case PROTO3: {
                return PROTO3;
            }
            case THRIFT: {
                return THRIFT;
            }
        }
        throw new UnsupportedOperationException("BUG: " + encoding.name());
    }
}

