/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.amqp;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import zipkin2.reporter.Call;
import zipkin2.reporter.Callback;
import zipkin2.reporter.CheckResult;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Sender;

public final class RabbitMQSender
extends Sender {
    final Encoding encoding;
    final int messageMaxBytes;
    final List<Address> addresses;
    final String queue;
    final ConnectionFactory connectionFactory;
    volatile Connection connection;
    volatile boolean closeCalled;
    final ThreadLocal<Channel> CHANNEL = new ThreadLocal();

    public static RabbitMQSender create(String addresses) {
        return RabbitMQSender.newBuilder().addresses(addresses).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    RabbitMQSender(Builder builder) {
        if (builder.addresses == null) {
            throw new NullPointerException("addresses == null");
        }
        this.encoding = builder.encoding;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.addresses = builder.addresses;
        this.queue = builder.queue;
        this.connectionFactory = builder.connectionFactory.clone();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding.listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding.listSizeInBytes(encodedSizeInBytes);
    }

    @Deprecated
    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        byte[] message = this.encoding.encode(encodedSpans);
        return new RabbitMQCall(message);
    }

    public void send(List<byte[]> encodedSpans) throws IOException {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        this.publish(this.encoding.encode(encodedSpans));
    }

    void publish(byte[] message) throws IOException {
        this.localChannel().basicPublish("", this.queue, null, message);
    }

    @Deprecated
    public CheckResult check() {
        try {
            if (this.localChannel().isOpen()) {
                return CheckResult.OK;
            }
            throw new IllegalStateException("Not Open");
        }
        catch (Throwable e) {
            Call.propagateIfFatal((Throwable)e);
            return CheckResult.failed((Throwable)e);
        }
    }

    public String toString() {
        return "RabbitMQSender{addresses=" + this.addresses + ", queue=" + this.queue + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection get() {
        if (this.connection == null) {
            RabbitMQSender rabbitMQSender = this;
            synchronized (rabbitMQSender) {
                if (this.connection == null) {
                    this.connection = this.newConnection();
                }
            }
        }
        return this.connection;
    }

    Connection newConnection() {
        try {
            return this.connectionFactory.newConnection(this.addresses);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to establish connection to RabbitMQ server", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Unable to establish connection to RabbitMQ server", e);
        }
    }

    public synchronized void close() throws IOException {
        if (this.closeCalled) {
            return;
        }
        Connection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
        this.closeCalled = true;
    }

    Channel localChannel() throws IOException {
        Channel channel = this.CHANNEL.get();
        if (channel == null) {
            channel = this.get().createChannel();
            this.CHANNEL.set(channel);
        }
        return channel;
    }

    static List<Address> convertAddresses(String addresses) {
        String[] addressStrings = addresses.split(",");
        Address[] addressArray = new Address[addressStrings.length];
        for (int i = 0; i < addressStrings.length; ++i) {
            String[] splitAddress = addressStrings[i].split(":");
            String host = splitAddress[0];
            Integer port = null;
            try {
                if (splitAddress.length == 2) {
                    port = Integer.parseInt(splitAddress[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            addressArray[i] = port != null ? new Address(host, port.intValue()) : new Address(host);
        }
        return Arrays.asList(addressArray);
    }

    class RabbitMQCall
    extends Call.Base<Void> {
        private final byte[] message;

        RabbitMQCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            RabbitMQSender.this.publish(this.message);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                RabbitMQSender.this.publish(this.message);
                callback.onSuccess(null);
            }
            catch (Throwable t) {
                Call.propagateIfFatal((Throwable)t);
                callback.onError(t);
            }
        }

        public Call<Void> clone() {
            return new RabbitMQCall(this.message);
        }
    }

    public static final class Builder {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        List<Address> addresses;
        String queue = "zipkin";
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 500000;

        Builder(RabbitMQSender sender) {
            this.connectionFactory = sender.connectionFactory.clone();
            this.addresses = sender.addresses;
            this.queue = sender.queue;
            this.encoding = sender.encoding;
            this.messageMaxBytes = sender.messageMaxBytes;
        }

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses == null");
            }
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(String addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses == null");
            }
            this.addresses = RabbitMQSender.convertAddresses(addresses);
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionFactory.setConnectionTimeout(connectionTimeout);
            return this;
        }

        public Builder virtualHost(String virtualHost) {
            this.connectionFactory.setVirtualHost(virtualHost);
            return this;
        }

        public Builder username(String username) {
            this.connectionFactory.setUsername(username);
            return this;
        }

        public Builder password(String password) {
            this.connectionFactory.setPassword(password);
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final RabbitMQSender build() {
            return new RabbitMQSender(this);
        }

        Builder() {
        }
    }
}

