/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.kafka08;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AwaitableCallback;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.kafka08.;

@AutoValue
public abstract class KafkaSender
extends Sender {
    volatile boolean provisioned;
    volatile boolean closeCalled;

    public static KafkaSender create(String bootstrapServers) {
        return KafkaSender.newBuilder().bootstrapServers(bootstrapServers).build();
    }

    public static Builder newBuilder() {
        Properties properties = new Properties();
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("acks", "0");
        return new .AutoValue_KafkaSender.Builder().encoding(Encoding.JSON).properties(properties).topic("zipkin").overrides(Collections.EMPTY_MAP).messageMaxBytes(1000000);
    }

    public abstract Builder toBuilder();

    abstract BytesMessageEncoder encoder();

    abstract String topic();

    abstract Properties properties();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding().listSizeInBytes(encodedSizeInBytes);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        byte[] message = this.encoder().encode(encodedSpans);
        return new KafkaCall(message);
    }

    public CheckResult check() {
        try {
            this.get().partitionsFor(this.topic());
            return CheckResult.OK;
        }
        catch (RuntimeException e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    KafkaProducer<byte[], byte[]> get() {
        KafkaProducer result = new KafkaProducer(this.properties());
        this.provisioned = true;
        return result;
    }

    public synchronized void close() {
        if (this.closeCalled) {
            return;
        }
        if (this.provisioned) {
            this.get().close();
        }
        this.closeCalled = true;
    }

    public final String toString() {
        return "KafkaSender{bootstrapServers=" + this.properties().get("bootstrap.servers") + ", topic=" + this.topic() + "}";
    }

    KafkaSender() {
    }

    static final class CallbackAdapter
    implements org.apache.kafka.clients.producer.Callback {
        final Callback<Void> delegate;

        CallbackAdapter(Callback<Void> delegate) {
            this.delegate = delegate;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception == null) {
                this.delegate.onSuccess(null);
            } else {
                this.delegate.onError((Throwable)exception);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    class KafkaCall
    extends Call.Base<Void> {
        private final byte[] message;

        KafkaCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() {
            AwaitableCallback callback = new AwaitableCallback();
            KafkaSender.this.get().send(new ProducerRecord(KafkaSender.this.topic(), (Object)this.message), (org.apache.kafka.clients.producer.Callback)new CallbackAdapter((Callback<Void>)callback));
            callback.await();
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            KafkaSender.this.get().send(new ProducerRecord(KafkaSender.this.topic(), (Object)this.message), (org.apache.kafka.clients.producer.Callback)new CallbackAdapter(callback));
        }

        public Call<Void> clone() {
            return new KafkaCall(this.message);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder properties(Properties var1);

        public abstract Builder topic(String var1);

        abstract Properties properties();

        public final Builder bootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("bootstrapServers == null");
            }
            this.properties().put("bootstrap.servers", bootstrapServers);
            return this;
        }

        public abstract Builder messageMaxBytes(int var1);

        public final Builder overrides(Map<String, ?> overrides) {
            if (overrides == null) {
                throw new NullPointerException("overrides == null");
            }
            this.properties().putAll(overrides);
            return this;
        }

        public abstract Builder encoding(Encoding var1);

        abstract Encoding encoding();

        public final KafkaSender build() {
            return this.encoder(BytesMessageEncoder.forEncoding((Encoding)this.encoding())).autoBuild();
        }

        abstract Builder encoder(BytesMessageEncoder var1);

        public abstract KafkaSender autoBuild();

        Builder() {
        }
    }
}

